/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.app.rabbit.source;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Envelope;
import org.aopalliance.aop.Advice;
import org.springframework.amqp.core.AcknowledgeMode;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.rabbit.config.RetryInterceptorBuilder;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.listener.AbstractMessageListenerContainer;
import org.springframework.amqp.rabbit.listener.SimpleMessageListenerContainer;
import org.springframework.amqp.rabbit.retry.MessageRecoverer;
import org.springframework.amqp.rabbit.retry.RejectAndDontRequeueRecoverer;
import org.springframework.amqp.rabbit.support.DefaultMessagePropertiesConverter;
import org.springframework.amqp.rabbit.support.MessagePropertiesConverter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.amqp.RabbitProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.stream.annotation.Bindings;
import org.springframework.cloud.stream.annotation.EnableBinding;
import org.springframework.cloud.stream.app.rabbit.source.RabbitSourceProperties;
import org.springframework.cloud.stream.messaging.Source;
import org.springframework.context.annotation.Bean;
import org.springframework.integration.amqp.inbound.AmqpInboundChannelAdapter;
import org.springframework.integration.amqp.support.AmqpHeaderMapper;
import org.springframework.integration.amqp.support.DefaultAmqpHeaderMapper;
import org.springframework.retry.interceptor.RetryOperationsInterceptor;
import org.springframework.util.Assert;

@EnableBinding(value={Source.class})
@EnableConfigurationProperties(value={RabbitSourceProperties.class})
public class RabbitSourceConfiguration {
    private static final MessagePropertiesConverter inboundMessagePropertiesConverter = new DefaultMessagePropertiesConverter(){

        public MessageProperties toMessageProperties(AMQP.BasicProperties source, Envelope envelope, String charset) {
            MessageProperties properties = super.toMessageProperties(source, envelope, charset);
            properties.setDeliveryMode(null);
            return properties;
        }
    };
    @Autowired
    @Bindings(value=RabbitSourceConfiguration.class)
    private Source channels;
    @Autowired
    private RabbitProperties rabbitProperties;
    @Autowired
    private RabbitSourceProperties properties;
    @Autowired
    private ConnectionFactory rabbitConnectionFactory;

    @Bean
    public SimpleMessageListenerContainer container() {
        Integer transactionSize;
        Integer prefetch;
        Integer maxConcurrency;
        Integer concurrency;
        SimpleMessageListenerContainer container = new SimpleMessageListenerContainer(this.rabbitConnectionFactory);
        RabbitProperties.Listener listenerProperties = this.rabbitProperties.getListener();
        AcknowledgeMode acknowledgeMode = listenerProperties.getAcknowledgeMode();
        if (acknowledgeMode != null) {
            container.setAcknowledgeMode(acknowledgeMode);
        }
        if ((concurrency = listenerProperties.getConcurrency()) != null) {
            container.setConcurrentConsumers(concurrency.intValue());
        }
        if ((maxConcurrency = listenerProperties.getMaxConcurrency()) != null) {
            container.setMaxConcurrentConsumers(maxConcurrency.intValue());
        }
        if ((prefetch = listenerProperties.getPrefetch()) != null) {
            container.setPrefetchCount(prefetch.intValue());
        }
        if ((transactionSize = listenerProperties.getTransactionSize()) != null) {
            container.setTxSize(transactionSize.intValue());
        }
        container.setDefaultRequeueRejected(this.properties.getRequeue());
        container.setChannelTransacted(this.properties.getTransacted());
        Object[] queues = this.properties.getQueues();
        Assert.state((queues.length > 0 ? 1 : 0) != 0, (String)"At least one queue is required");
        Assert.noNullElements((Object[])queues, (String)"queues cannot have null elements");
        container.setQueueNames((String[])queues);
        if (this.properties.isEnableRetry()) {
            container.setAdviceChain(new Advice[]{this.rabbitSourceRetryInterceptor()});
        }
        container.setMessagePropertiesConverter(inboundMessagePropertiesConverter);
        return container;
    }

    @Bean
    public AmqpInboundChannelAdapter adapter() {
        AmqpInboundChannelAdapter adapter = new AmqpInboundChannelAdapter((AbstractMessageListenerContainer)this.container());
        adapter.setOutputChannel(this.channels.output());
        DefaultAmqpHeaderMapper headerMapper = new DefaultAmqpHeaderMapper();
        headerMapper.setRequestHeaderNames(this.properties.getMappedRequestHeaders());
        adapter.setHeaderMapper((AmqpHeaderMapper)headerMapper);
        return adapter;
    }

    @Bean
    public RetryOperationsInterceptor rabbitSourceRetryInterceptor() {
        return (RetryOperationsInterceptor)RetryInterceptorBuilder.stateless().maxAttempts(this.properties.getMaxAttempts()).backOffOptions((long)this.properties.getInitialRetryInterval(), this.properties.getRetryMultiplier(), (long)this.properties.getMaxRetryInterval()).recoverer((MessageRecoverer)new RejectAndDontRequeueRecoverer()).build();
    }
}

