/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.app.mail.source;

import java.util.Map;
import java.util.Properties;
import javax.mail.URLName;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.stream.annotation.EnableBinding;
import org.springframework.cloud.stream.app.mail.source.MailSourceProperties;
import org.springframework.cloud.stream.app.trigger.TriggerConfiguration;
import org.springframework.cloud.stream.app.trigger.TriggerPropertiesMaxMessagesDefaultOne;
import org.springframework.cloud.stream.messaging.Source;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.integration.dsl.IntegrationFlow;
import org.springframework.integration.dsl.IntegrationFlowBuilder;
import org.springframework.integration.dsl.IntegrationFlows;
import org.springframework.integration.dsl.SourcePollingChannelAdapterSpec;
import org.springframework.integration.dsl.core.MessageProducerSpec;
import org.springframework.integration.dsl.core.MessageSourceSpec;
import org.springframework.integration.dsl.mail.Mail;
import org.springframework.integration.dsl.mail.MailInboundChannelAdapterSpec;
import org.springframework.integration.dsl.support.Consumer;
import org.springframework.integration.dsl.support.Transformers;
import org.springframework.integration.scheduling.PollerMetadata;
import org.springframework.integration.transformer.GenericTransformer;

@EnableBinding(value={Source.class})
@EnableConfigurationProperties(value={MailSourceProperties.class, TriggerPropertiesMaxMessagesDefaultOne.class})
@Import(value={TriggerConfiguration.class})
public class MailSourceConfiguration {
    @Autowired
    @Qualifier(value="defaultPoller")
    private PollerMetadata defaultPoller;
    @Autowired
    private MailSourceProperties properties;

    @Bean
    public IntegrationFlow mailInboundFlow() {
        return ((IntegrationFlowBuilder)((IntegrationFlowBuilder)this.getFlowBuilder().transform((GenericTransformer)Transformers.fromMail((String)this.properties.getCharset()))).channel("output")).get();
    }

    private IntegrationFlowBuilder getFlowBuilder() {
        IntegrationFlowBuilder flowBuilder;
        URLName urlName = this.properties.getUrl();
        if (this.properties.isIdleImap()) {
            flowBuilder = this.getIdleImapFlow(urlName);
        } else {
            MailInboundChannelAdapterSpec adapterSpec;
            switch (urlName.getProtocol().toUpperCase()) {
                case "IMAP": 
                case "IMAPS": {
                    adapterSpec = this.getImapFlowBuilder(urlName);
                    break;
                }
                case "POP3": 
                case "POP3S": {
                    adapterSpec = this.getPop3FlowBuilder(urlName);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported mail protocol: " + urlName.getProtocol());
                }
            }
            flowBuilder = IntegrationFlows.from((MessageSourceSpec)adapterSpec.javaMailProperties(this.getJavaMailProperties(urlName)).selectorExpression(this.properties.getExpression()).shouldDeleteMessages(this.properties.isDelete()), (Consumer)new Consumer<SourcePollingChannelAdapterSpec>(){

                public void accept(SourcePollingChannelAdapterSpec sourcePollingChannelAdapterSpec) {
                    sourcePollingChannelAdapterSpec.poller(MailSourceConfiguration.this.defaultPoller);
                }
            });
        }
        return flowBuilder;
    }

    private IntegrationFlowBuilder getIdleImapFlow(URLName urlName) {
        return IntegrationFlows.from((MessageProducerSpec)Mail.imapIdleAdapter((String)urlName.toString()).shouldDeleteMessages(this.properties.isDelete()).javaMailProperties(this.getJavaMailProperties(urlName)).selectorExpression(this.properties.getExpression()).shouldMarkMessagesAsRead(this.properties.isMarkAsRead()));
    }

    private MailInboundChannelAdapterSpec getPop3FlowBuilder(URLName urlName) {
        return Mail.pop3InboundAdapter((String)urlName.toString());
    }

    private MailInboundChannelAdapterSpec getImapFlowBuilder(URLName urlName) {
        return Mail.imapInboundAdapter((String)urlName.toString()).shouldMarkMessagesAsRead(this.properties.isMarkAsRead());
    }

    private Properties getJavaMailProperties(URLName urlName) {
        Properties javaMailProperties = new Properties();
        switch (urlName.getProtocol().toUpperCase()) {
            case "IMAP": {
                javaMailProperties.setProperty("mail.imap.socketFactory.class", "javax.net.SocketFactory");
                javaMailProperties.setProperty("mail.imap.socketFactory.fallback", "false");
                javaMailProperties.setProperty("mail.store.protocol", "imap");
                break;
            }
            case "IMAPS": {
                javaMailProperties.setProperty("mail.imap.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
                javaMailProperties.setProperty("mail.imap.socketFactory.fallback", "false");
                javaMailProperties.setProperty("mail.store.protocol", "imaps");
                break;
            }
            case "POP3": {
                javaMailProperties.setProperty("mail.pop3.socketFactory.class", "javax.net.SocketFactory");
                javaMailProperties.setProperty("mail.pop3.socketFactory.fallback", "false");
                javaMailProperties.setProperty("mail.store.protocol", "pop3");
                break;
            }
            case "POP3S": {
                javaMailProperties.setProperty("mail.pop3.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
                javaMailProperties.setProperty("mail.pop3.socketFactory.fallback", "false");
                javaMailProperties.setProperty("mail.store.protocol", "pop3s");
            }
        }
        javaMailProperties.putAll((Map<?, ?>)this.properties.getJavaMailProperties());
        return javaMailProperties;
    }
}

