/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.app.jms.source;

import javax.jms.ConnectionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.jms.JmsProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.stream.annotation.Bindings;
import org.springframework.cloud.stream.annotation.EnableBinding;
import org.springframework.cloud.stream.app.jms.source.JmsSourceProperties;
import org.springframework.cloud.stream.messaging.Source;
import org.springframework.context.annotation.Bean;
import org.springframework.integration.jms.ChannelPublishingJmsMessageListener;
import org.springframework.integration.jms.JmsMessageDrivenEndpoint;
import org.springframework.jms.listener.AbstractMessageListenerContainer;
import org.springframework.jms.listener.DefaultMessageListenerContainer;
import org.springframework.jms.listener.SimpleMessageListenerContainer;

@EnableBinding(value={Source.class})
@EnableConfigurationProperties(value={JmsSourceProperties.class})
public class JmsSourceConfiguration {
    @Autowired
    @Bindings(value=JmsSourceConfiguration.class)
    private Source channels;
    @Autowired
    private JmsSourceProperties properties;
    @Autowired
    private JmsProperties jmsProperties;
    @Autowired
    private ConnectionFactory connectionFactory;

    @Bean
    public JmsMessageDrivenEndpoint adapter() {
        return new JmsMessageDrivenEndpoint(this.container(), this.listener());
    }

    @Bean
    public AbstractMessageListenerContainer container() {
        SimpleMessageListenerContainer container;
        JmsProperties.Listener listenerProperties = this.jmsProperties.getListener();
        if (this.properties.isSessionTransacted()) {
            DefaultMessageListenerContainer dmlc = new DefaultMessageListenerContainer();
            dmlc.setSessionTransacted(true);
            if (listenerProperties.getConcurrency() != null) {
                dmlc.setConcurrentConsumers(listenerProperties.getConcurrency().intValue());
            }
            if (listenerProperties.getMaxConcurrency() != null) {
                dmlc.setMaxConcurrentConsumers(listenerProperties.getMaxConcurrency().intValue());
            }
            container = dmlc;
        } else {
            SimpleMessageListenerContainer smlc = new SimpleMessageListenerContainer();
            smlc.setSessionTransacted(false);
            if (listenerProperties != null && listenerProperties.getConcurrency() != null) {
                smlc.setConcurrentConsumers(listenerProperties.getConcurrency().intValue());
            }
            container = smlc;
        }
        container.setConnectionFactory(this.connectionFactory);
        if (this.properties.getClientId() != null) {
            container.setClientId(this.properties.getClientId());
        }
        container.setDestinationName(this.properties.getDestination());
        if (this.properties.getMessageSelector() != null) {
            container.setMessageSelector(this.properties.getMessageSelector());
        }
        container.setPubSubDomain(this.jmsProperties.isPubSubDomain());
        if (this.properties.getMessageSelector() != null && listenerProperties.getAcknowledgeMode() != null) {
            container.setSessionAcknowledgeMode(listenerProperties.getAcknowledgeMode().getMode());
        }
        if (this.properties.getSubscriptionDurable() != null) {
            container.setSubscriptionDurable(this.properties.getSubscriptionDurable().booleanValue());
        }
        if (this.properties.getSubscriptionName() != null) {
            container.setSubscriptionName(this.properties.getSubscriptionName());
        }
        if (this.properties.getSubscriptionShared() != null) {
            container.setSubscriptionShared(this.properties.getSubscriptionShared().booleanValue());
        }
        return container;
    }

    @Bean
    public ChannelPublishingJmsMessageListener listener() {
        ChannelPublishingJmsMessageListener listener = new ChannelPublishingJmsMessageListener();
        listener.setRequestChannel(this.channels.output());
        return listener;
    }
}

