/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.app.http.source;

import java.util.Collections;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.stream.annotation.EnableBinding;
import org.springframework.cloud.stream.messaging.Source;
import org.springframework.http.HttpStatus;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@EnableBinding(value={Source.class})
public class HttpSourceConfiguration {
    @Autowired
    private Source channels;

    @RequestMapping(path={"${http.pathPattern:/}"}, method={RequestMethod.POST}, consumes={"text/*", "application/json"})
    @ResponseStatus(value=HttpStatus.ACCEPTED)
    public void handleRequest(@RequestBody String body, @RequestHeader(value="Content-Type") Object contentType) {
        this.sendMessage(body, contentType);
    }

    @RequestMapping(path={"${http.pathPattern:/}"}, method={RequestMethod.POST}, consumes={"*/*"})
    @ResponseStatus(value=HttpStatus.ACCEPTED)
    public void handleRequest(@RequestBody byte[] body, @RequestHeader(value="Content-Type") Object contentType) {
        this.sendMessage(body, contentType);
    }

    private void sendMessage(Object body, Object contentType) {
        this.channels.output().send(MessageBuilder.createMessage((Object)body, (MessageHeaders)new MessageHeaders(Collections.singletonMap("contentType", contentType))));
    }
}

