/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.app.gemfire.source;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.pdx.PdxInstance;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.stream.annotation.EnableBinding;
import org.springframework.cloud.stream.app.gemfire.JsonObjectTransformer;
import org.springframework.cloud.stream.app.gemfire.config.GemfireClientRegionConfiguration;
import org.springframework.cloud.stream.app.gemfire.config.GemfirePoolConfiguration;
import org.springframework.cloud.stream.app.gemfire.source.GemfireSourceProperties;
import org.springframework.cloud.stream.app.gemfire.source.KeyInterestConfiguration;
import org.springframework.cloud.stream.messaging.Source;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.PropertySource;
import org.springframework.integration.channel.DirectChannel;
import org.springframework.integration.dsl.IntegrationFlow;
import org.springframework.integration.dsl.IntegrationFlowBuilder;
import org.springframework.integration.dsl.IntegrationFlows;
import org.springframework.integration.gemfire.inbound.CacheListeningMessageProducer;
import org.springframework.integration.router.AbstractMessageRouter;
import org.springframework.integration.router.PayloadTypeRouter;
import org.springframework.messaging.MessageChannel;

@EnableBinding(value={Source.class})
@Import(value={KeyInterestConfiguration.class, GemfirePoolConfiguration.class, GemfireClientRegionConfiguration.class})
@EnableConfigurationProperties(value={GemfireSourceProperties.class})
@PropertySource(value={"classpath:gemfire-source.properties"})
public class GemfireSourceConfiguration {
    @Autowired
    private GemfireSourceProperties config;
    @Resource(name="clientRegion")
    private Region<String, ?> region;
    @Autowired
    @Qualifier(value="output")
    private MessageChannel output;

    @Bean
    public MessageChannel convertToStringChannel() {
        return new DirectChannel();
    }

    @Bean
    public MessageChannel routerChannel() {
        return new DirectChannel();
    }

    @Bean
    PayloadTypeRouter payloadTypeRouter() {
        PayloadTypeRouter router = new PayloadTypeRouter();
        router.setDefaultOutputChannel(this.output);
        router.setChannelMapping(PdxInstance.class.getName(), "convertToStringChannel");
        return router;
    }

    @Bean
    public IntegrationFlow startFlow() {
        return ((IntegrationFlowBuilder)IntegrationFlows.from((MessageChannel)this.routerChannel()).route((AbstractMessageRouter)this.payloadTypeRouter())).get();
    }

    @Bean
    JsonObjectTransformer transformer() {
        return new JsonObjectTransformer();
    }

    @Bean
    IntegrationFlow convertToString() {
        return ((IntegrationFlowBuilder)((IntegrationFlowBuilder)IntegrationFlows.from((MessageChannel)this.convertToStringChannel()).transform((Object)this.transformer(), "toString")).channel(this.output)).get();
    }

    @Bean
    public CacheListeningMessageProducer cacheListeningMessageProducer() {
        CacheListeningMessageProducer cacheListeningMessageProducer = new CacheListeningMessageProducer(this.region);
        cacheListeningMessageProducer.setOutputChannel(this.routerChannel());
        cacheListeningMessageProducer.setPayloadExpression(this.config.getCacheEventExpression());
        return cacheListeningMessageProducer;
    }
}

