/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.app.ftp.source;

import org.apache.commons.net.ftp.FTPFile;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.stream.annotation.EnableBinding;
import org.springframework.cloud.stream.app.file.FileConsumerProperties;
import org.springframework.cloud.stream.app.file.FileReadingMode;
import org.springframework.cloud.stream.app.file.FileUtils;
import org.springframework.cloud.stream.app.ftp.FtpSessionFactoryConfiguration;
import org.springframework.cloud.stream.app.ftp.source.FtpSourceProperties;
import org.springframework.cloud.stream.app.trigger.TriggerConfiguration;
import org.springframework.cloud.stream.app.trigger.TriggerPropertiesMaxMessagesDefaultUnlimited;
import org.springframework.cloud.stream.messaging.Source;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.integration.dsl.IntegrationFlow;
import org.springframework.integration.dsl.IntegrationFlowBuilder;
import org.springframework.integration.dsl.IntegrationFlows;
import org.springframework.integration.dsl.MessageSourceSpec;
import org.springframework.integration.file.filters.ChainFileListFilter;
import org.springframework.integration.file.filters.FileListFilter;
import org.springframework.integration.file.remote.session.SessionFactory;
import org.springframework.integration.ftp.dsl.Ftp;
import org.springframework.integration.ftp.dsl.FtpInboundChannelAdapterSpec;
import org.springframework.integration.ftp.filters.FtpPersistentAcceptOnceFileListFilter;
import org.springframework.integration.ftp.filters.FtpRegexPatternFileListFilter;
import org.springframework.integration.ftp.filters.FtpSimplePatternFileListFilter;
import org.springframework.integration.metadata.ConcurrentMetadataStore;
import org.springframework.integration.scheduling.PollerMetadata;
import org.springframework.util.StringUtils;

@EnableBinding(value={Source.class})
@EnableConfigurationProperties(value={FtpSourceProperties.class, FileConsumerProperties.class, TriggerPropertiesMaxMessagesDefaultUnlimited.class})
@Import(value={TriggerConfiguration.class, FtpSessionFactoryConfiguration.class})
public class FtpSourceConfiguration {
    @Autowired
    @Qualifier(value="org.springframework.integration.context.defaultPollerMetadata")
    private PollerMetadata defaultPoller;
    @Autowired
    private Source source;
    @Autowired
    private ConcurrentMetadataStore metadataStore;

    @Bean
    public IntegrationFlow ftpInboundFlow(SessionFactory<FTPFile> ftpSessionFactory, FtpSourceProperties properties, FileConsumerProperties fileConsumerProperties) {
        FtpInboundChannelAdapterSpec messageSourceBuilder = (FtpInboundChannelAdapterSpec)((FtpInboundChannelAdapterSpec)((FtpInboundChannelAdapterSpec)((FtpInboundChannelAdapterSpec)((FtpInboundChannelAdapterSpec)((FtpInboundChannelAdapterSpec)((FtpInboundChannelAdapterSpec)Ftp.inboundAdapter(ftpSessionFactory).preserveTimestamp(properties.isPreserveTimestamp())).remoteDirectory(properties.getRemoteDir())).remoteFileSeparator(properties.getRemoteFileSeparator())).localDirectory(properties.getLocalDir())).autoCreateLocalDirectory(properties.isAutoCreateLocalDir())).temporaryFileSuffix(properties.getTmpFileSuffix())).deleteRemoteFiles(properties.isDeleteRemoteFiles());
        ChainFileListFilter chainFileListFilter = new ChainFileListFilter();
        if (StringUtils.hasText((String)properties.getFilenamePattern())) {
            chainFileListFilter.addFilter((FileListFilter)new FtpSimplePatternFileListFilter(properties.getFilenamePattern()));
        } else if (properties.getFilenameRegex() != null) {
            chainFileListFilter.addFilter((FileListFilter)new FtpRegexPatternFileListFilter(properties.getFilenameRegex()));
        }
        chainFileListFilter.addFilter((FileListFilter)new FtpPersistentAcceptOnceFileListFilter(this.metadataStore, "ftpSource/"));
        messageSourceBuilder.filter((FileListFilter)chainFileListFilter);
        IntegrationFlowBuilder flowBuilder = IntegrationFlows.from((MessageSourceSpec)messageSourceBuilder, e -> e.poller(this.defaultPoller));
        if (fileConsumerProperties.getMode() != FileReadingMode.ref) {
            flowBuilder = FileUtils.enhanceFlowForReadingMode((IntegrationFlowBuilder)flowBuilder, (FileConsumerProperties)fileConsumerProperties);
        }
        return ((IntegrationFlowBuilder)flowBuilder.channel(this.source.output())).get();
    }
}

