/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.app.websocket.sink.trace;

import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.springframework.cloud.stream.app.websocket.sink.trace.Trace;

public class InMemoryTraceRepository {
    private int capacity = 100;
    private boolean reverse = true;
    private final List<Trace> traces = new LinkedList<Trace>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReverse(boolean reverse) {
        List<Trace> list = this.traces;
        synchronized (list) {
            this.reverse = reverse;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCapacity(int capacity) {
        List<Trace> list = this.traces;
        synchronized (list) {
            this.capacity = capacity;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Trace> findAll() {
        List<Trace> list = this.traces;
        synchronized (list) {
            return Collections.unmodifiableList(this.traces);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Map<String, Object> map) {
        Trace trace = new Trace(new Date(), map);
        List<Trace> list = this.traces;
        synchronized (list) {
            while (this.traces.size() >= this.capacity) {
                this.traces.remove(this.reverse ? this.capacity - 1 : 0);
            }
            if (this.reverse) {
                this.traces.add(0, trace);
            } else {
                this.traces.add(trace);
            }
        }
    }
}

