/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.app.websocket.sink;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.stream.app.websocket.sink.WebsocketSinkProperties;
import org.springframework.cloud.stream.app.websocket.sink.WebsocketSinkServerInitializer;

public class WebsocketSinkServer {
    private static final Log logger = LogFactory.getLog(WebsocketSinkServer.class);
    static final List<Channel> channels = Collections.synchronizedList(new ArrayList());
    @Autowired
    WebsocketSinkProperties properties;
    @Autowired
    WebsocketSinkServerInitializer initializer;
    private EventLoopGroup bossGroup;
    private EventLoopGroup workerGroup;
    private int port;

    public int getPort() {
        return this.port;
    }

    @PostConstruct
    public void init() {
        this.bossGroup = new NioEventLoopGroup(this.properties.getThreads());
        this.workerGroup = new NioEventLoopGroup();
    }

    @PreDestroy
    public void shutdown() {
        this.bossGroup.shutdownGracefully();
        this.workerGroup.shutdownGracefully();
    }

    public void run() throws InterruptedException {
        NioServerSocketChannel channel = (NioServerSocketChannel)((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class)).handler((ChannelHandler)new LoggingHandler(this.nettyLogLevel()))).childHandler((ChannelHandler)this.initializer).bind(this.properties.getPort()).sync().channel();
        this.port = channel.localAddress().getPort();
        this.dumpProperties();
    }

    private void dumpProperties() {
        logger.info((Object)"\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588");
        logger.info((Object)"                >> websocket-sink config <<                ");
        logger.info((Object)"");
        logger.info((Object)String.format("port:     %s", this.port));
        logger.info((Object)String.format("ssl:               %s", this.properties.isSsl()));
        logger.info((Object)String.format("path:     %s", this.properties.getPath()));
        logger.info((Object)String.format("logLevel: %s", this.properties.getLogLevel()));
        logger.info((Object)String.format("threads:           %s", this.properties.getThreads()));
        logger.info((Object)"");
        logger.info((Object)"\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588");
    }

    private LogLevel nettyLogLevel() {
        return LogLevel.valueOf((String)this.properties.getLogLevel().toUpperCase());
    }
}

