/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.app.websocket.sink;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.actuate.trace.TraceRepository;
import org.springframework.cloud.stream.app.websocket.sink.WebsocketSinkProperties;
import org.springframework.cloud.stream.app.websocket.sink.WebsocketSinkServer;

class WebsocketSinkServerHandler
extends SimpleChannelInboundHandler<Object> {
    private static final Log logger = LogFactory.getLog(WebsocketSinkServerHandler.class);
    private final boolean traceEnabled;
    private final TraceRepository websocketTraceRepository;
    private final WebsocketSinkProperties properties;
    private WebSocketServerHandshaker handshaker;

    public WebsocketSinkServerHandler(TraceRepository websocketTraceRepository, WebsocketSinkProperties properties, boolean traceEnabled) {
        this.websocketTraceRepository = websocketTraceRepository;
        this.properties = properties;
        this.traceEnabled = traceEnabled;
    }

    public void channelRead0(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof FullHttpRequest) {
            this.handleHttpRequest(ctx, (FullHttpRequest)msg);
        } else if (msg instanceof WebSocketFrame) {
            this.handleWebSocketFrame(ctx, (WebSocketFrame)msg);
        }
    }

    public void channelReadComplete(ChannelHandlerContext ctx) {
        ctx.flush();
    }

    private void handleHttpRequest(ChannelHandlerContext ctx, FullHttpRequest req) {
        if (!req.getDecoderResult().isSuccess()) {
            logger.warn((Object)String.format("Bad request: %s", req.getUri()));
            this.sendHttpResponse(ctx, req, (FullHttpResponse)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.BAD_REQUEST));
            return;
        }
        if (req.getMethod() != HttpMethod.GET) {
            logger.warn((Object)String.format("Unsupported HTTP method: %s", req.getMethod()));
            this.sendHttpResponse(ctx, req, (FullHttpResponse)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.FORBIDDEN));
            return;
        }
        if (!this.additionalHttpRequestHandler(ctx, req)) {
            return;
        }
        WebSocketServerHandshakerFactory wsFactory = new WebSocketServerHandshakerFactory(this.getWebSocketLocation(req), null, true);
        this.handshaker = wsFactory.newHandshaker((HttpRequest)req);
        if (this.handshaker == null) {
            WebSocketServerHandshakerFactory.sendUnsupportedVersionResponse((Channel)ctx.channel());
        } else {
            this.handshaker.handshake(ctx.channel(), req);
            WebsocketSinkServer.channels.add(ctx.channel());
        }
    }

    private void handleWebSocketFrame(ChannelHandlerContext ctx, WebSocketFrame frame) {
        if (frame instanceof CloseWebSocketFrame) {
            this.addTraceForFrame(frame, "close");
            this.handshaker.close(ctx.channel(), (CloseWebSocketFrame)frame.retain());
            return;
        }
        if (frame instanceof PingWebSocketFrame) {
            this.addTraceForFrame(frame, "ping");
            ctx.channel().write((Object)new PongWebSocketFrame(frame.content().retain()));
            return;
        }
        if (!(frame instanceof TextWebSocketFrame)) {
            throw new UnsupportedOperationException(String.format("%s frame types not supported", frame.getClass().getName()));
        }
        this.handleTextWebSocketFrameInternal((TextWebSocketFrame)frame, ctx);
    }

    private boolean additionalHttpRequestHandler(ChannelHandlerContext ctx, FullHttpRequest req) {
        return true;
    }

    private void handleTextWebSocketFrameInternal(TextWebSocketFrame frame, ChannelHandlerContext ctx) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)String.format("%s received %s", ctx.channel(), frame.text()));
        }
        this.addTraceForFrame((WebSocketFrame)frame, "text");
        ctx.channel().write((Object)new TextWebSocketFrame("Echo: " + frame.text()));
    }

    private void addTraceForFrame(WebSocketFrame frame, String type) {
        LinkedHashMap<String, String> trace = new LinkedHashMap<String, String>();
        trace.put("type", type);
        trace.put("direction", "in");
        if (frame instanceof TextWebSocketFrame) {
            trace.put("payload", ((TextWebSocketFrame)frame).text());
        }
        if (this.traceEnabled) {
            this.websocketTraceRepository.add(trace);
        }
    }

    private void sendHttpResponse(ChannelHandlerContext ctx, FullHttpRequest req, FullHttpResponse res) {
        if (res.getStatus().code() != 200) {
            ByteBuf buf = Unpooled.copiedBuffer((CharSequence)res.getStatus().toString(), (Charset)CharsetUtil.UTF_8);
            res.content().writeBytes(buf);
            buf.release();
            HttpHeaders.setContentLength((HttpMessage)res, (long)res.content().readableBytes());
        }
        ChannelFuture f = ctx.channel().writeAndFlush((Object)res);
        if (!HttpHeaders.isKeepAlive((HttpMessage)req) || res.getStatus().code() != 200) {
            f.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        logger.error((Object)"Websocket error", cause);
        cause.printStackTrace();
        ctx.close();
    }

    private String getWebSocketLocation(FullHttpRequest req) {
        String location = req.headers().get("Host") + this.properties.getPath();
        if (this.properties.isSsl()) {
            return "wss://" + location;
        }
        return "ws://" + location;
    }
}

