/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.app.websocket.sink.actuator;

import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.actuate.endpoint.AbstractEndpoint;
import org.springframework.boot.actuate.trace.Trace;
import org.springframework.boot.actuate.trace.TraceRepository;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="endpoints.websocketsinktrace", ignoreUnknownFields=true)
public class WebsocketSinkTraceEndpoint
extends AbstractEndpoint<List<Trace>> {
    private static final Log logger = LogFactory.getLog(WebsocketSinkTraceEndpoint.class);
    private boolean enabled;
    private final TraceRepository repository;

    public WebsocketSinkTraceEndpoint(TraceRepository repository) {
        super("websocketsinktrace");
        this.repository = repository;
    }

    @PostConstruct
    public void init() {
        logger.info((Object)String.format("/websocketsinktrace enabled: %b", this.enabled));
    }

    public List<Trace> invoke() {
        return this.repository.findAll();
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

