/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.app.sftp.sink;

import com.jcraft.jsch.ChannelSftp;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.stream.app.sftp.sink.SftpSinkProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.expression.EvaluationContext;
import org.springframework.integration.context.IntegrationContextUtils;
import org.springframework.integration.file.remote.session.CachingSessionFactory;
import org.springframework.integration.file.remote.session.SessionFactory;
import org.springframework.integration.sftp.session.DefaultSftpSessionFactory;

public class SftpSinkSessionFactoryConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public SessionFactory<ChannelSftp.LsEntry> sftpSessionFactory(SftpSinkProperties properties, BeanFactory beanFactory) {
        DefaultSftpSessionFactory sftpSessionFactory = new DefaultSftpSessionFactory();
        sftpSessionFactory.setHost(properties.getFactory().getHost());
        sftpSessionFactory.setPort(properties.getFactory().getPort());
        sftpSessionFactory.setUser(properties.getFactory().getUsername());
        sftpSessionFactory.setPassword(properties.getFactory().getPassword());
        sftpSessionFactory.setAllowUnknownKeys(properties.getFactory().isAllowUnknownKeys());
        if (properties.getFactory().getKnownHostsExpression() != null) {
            sftpSessionFactory.setKnownHosts((String)properties.getFactory().getKnownHostsExpression().getValue((EvaluationContext)IntegrationContextUtils.getEvaluationContext((BeanFactory)beanFactory), String.class));
        }
        if (properties.getFactory().getCacheSessions() != null) {
            CachingSessionFactory csf = new CachingSessionFactory((SessionFactory)sftpSessionFactory);
            return csf;
        }
        return sftpSessionFactory;
    }
}

