/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.app.sftp.sink;

import com.jcraft.jsch.ChannelSftp;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.stream.annotation.EnableBinding;
import org.springframework.cloud.stream.app.sftp.SftpSessionFactoryConfiguration;
import org.springframework.cloud.stream.app.sftp.sink.SftpSinkProperties;
import org.springframework.cloud.stream.messaging.Sink;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.integration.dsl.GenericEndpointSpec;
import org.springframework.integration.dsl.IntegrationFlow;
import org.springframework.integration.dsl.IntegrationFlowBuilder;
import org.springframework.integration.dsl.IntegrationFlows;
import org.springframework.integration.dsl.core.MessageHandlerSpec;
import org.springframework.integration.dsl.sftp.Sftp;
import org.springframework.integration.dsl.sftp.SftpMessageHandlerSpec;
import org.springframework.integration.dsl.support.Consumer;
import org.springframework.integration.file.remote.RemoteFileTemplate;
import org.springframework.integration.file.remote.handler.FileTransferringMessageHandler;
import org.springframework.integration.file.remote.session.SessionFactory;
import org.springframework.integration.file.support.FileExistsMode;
import org.springframework.integration.sftp.session.SftpRemoteFileTemplate;

@EnableBinding(value={Sink.class})
@EnableConfigurationProperties(value={SftpSinkProperties.class})
@Import(value={SftpSessionFactoryConfiguration.class})
public class SftpSinkConfiguration {
    @Autowired
    Sink sink;

    @Bean
    public IntegrationFlow ftpInboundFlow(SftpSinkProperties properties, SessionFactory<ChannelSftp.LsEntry> ftpSessionFactory) {
        SftpMessageHandlerSpec handlerSpec = (SftpMessageHandlerSpec)((SftpMessageHandlerSpec)((SftpMessageHandlerSpec)((SftpMessageHandlerSpec)Sftp.outboundAdapter((RemoteFileTemplate)new SftpRemoteFileTemplate(ftpSessionFactory), (FileExistsMode)properties.getMode()).remoteDirectory(properties.getRemoteDir())).remoteFileSeparator(properties.getRemoteFileSeparator())).autoCreateDirectory(properties.isAutoCreateDir())).temporaryFileSuffix(properties.getTmpFileSuffix());
        if (properties.getFilenameExpression() != null) {
            handlerSpec.fileNameExpression(properties.getFilenameExpression().getExpressionString());
        }
        return ((IntegrationFlowBuilder)IntegrationFlows.from((String)"input").handle((MessageHandlerSpec)handlerSpec, (Consumer)new Consumer<GenericEndpointSpec<FileTransferringMessageHandler<ChannelSftp.LsEntry>>>(){

            public void accept(GenericEndpointSpec<FileTransferringMessageHandler<ChannelSftp.LsEntry>> e) {
                e.autoStartup(false);
            }
        })).get();
    }
}

