/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.app.s3.sink;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.transfer.internal.S3ProgressListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.aws.core.env.ResourceIdResolver;
import org.springframework.cloud.stream.annotation.EnableBinding;
import org.springframework.cloud.stream.app.s3.AmazonS3Configuration;
import org.springframework.cloud.stream.app.s3.sink.AmazonS3SinkProperties;
import org.springframework.cloud.stream.messaging.Sink;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.expression.Expression;
import org.springframework.integration.annotation.ServiceActivator;
import org.springframework.integration.aws.outbound.S3MessageHandler;
import org.springframework.integration.expression.ValueExpression;
import org.springframework.messaging.MessageHandler;

@EnableBinding(value={Sink.class})
@EnableConfigurationProperties(value={AmazonS3SinkProperties.class})
@Import(value={AmazonS3Configuration.class})
public class AmazonS3SinkConfiguration {
    @Autowired(required=false)
    private S3MessageHandler.UploadMetadataProvider uploadMetadataProvider;
    @Autowired(required=false)
    private S3ProgressListener s3ProgressListener;

    @Bean
    @ServiceActivator(inputChannel="input")
    public MessageHandler amazonS3MessageHandler(AmazonS3 amazonS3, ResourceIdResolver resourceIdResolver, AmazonS3SinkProperties s3SinkProperties) {
        S3MessageHandler s3MessageHandler = s3SinkProperties.getBucket() != null ? new S3MessageHandler(amazonS3, s3SinkProperties.getBucket()) : new S3MessageHandler(amazonS3, s3SinkProperties.getBucketExpression());
        s3MessageHandler.setResourceIdResolver(resourceIdResolver);
        s3MessageHandler.setKeyExpression(s3SinkProperties.getKeyExpression());
        if (s3SinkProperties.getAcl() != null) {
            s3MessageHandler.setObjectAclExpression((Expression)new ValueExpression((Object)s3SinkProperties.getAcl()));
        } else {
            s3MessageHandler.setObjectAclExpression(s3SinkProperties.getAclExpression());
        }
        s3MessageHandler.setUploadMetadataProvider(this.uploadMetadataProvider);
        s3MessageHandler.setProgressListener(this.s3ProgressListener);
        return s3MessageHandler;
    }
}

