/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.app.router.sink;

import java.util.Properties;
import javax.validation.constraints.AssertTrue;
import javax.validation.constraints.NotNull;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.core.io.Resource;
import org.springframework.expression.Expression;
import org.springframework.integration.expression.FunctionExpression;

@ConfigurationProperties(value="router")
public class RouterSinkProperties {
    public static final Expression DEFAULT_EXPRESSION = new FunctionExpression(message -> message.getHeaders().get((Object)"routeTo"));
    private Properties variables;
    private Resource variablesLocation;
    private Expression expression = DEFAULT_EXPRESSION;
    private Resource script;
    private int refreshDelay = 60000;
    private String defaultOutputChannel = "nullChannel";
    private boolean resolutionRequired = false;
    private Properties destinationMappings;

    public Properties getVariables() {
        return this.variables;
    }

    public void setVariables(Properties variables) {
        this.variables = variables;
    }

    public Resource getVariablesLocation() {
        return this.variablesLocation;
    }

    public void setVariablesLocation(Resource variablesLocation) {
        this.variablesLocation = variablesLocation;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    public Resource getScript() {
        return this.script;
    }

    public void setScript(Resource script) {
        this.script = script;
    }

    @NotNull
    public String getDefaultOutputChannel() {
        return this.defaultOutputChannel;
    }

    public int getRefreshDelay() {
        return this.refreshDelay;
    }

    public void setRefreshDelay(int refreshDelay) {
        this.refreshDelay = refreshDelay;
    }

    public void setDefaultOutputChannel(String defaultOutputChannel) {
        this.defaultOutputChannel = defaultOutputChannel;
    }

    public boolean isResolutionRequired() {
        return this.resolutionRequired;
    }

    public void setResolutionRequired(boolean resolutionRequired) {
        this.resolutionRequired = resolutionRequired;
    }

    public Properties getDestinationMappings() {
        return this.destinationMappings;
    }

    public void setDestinationMappings(Properties destinationMappings) {
        this.destinationMappings = destinationMappings;
    }

    @AssertTrue(message="'expression' and 'script' are mutually exclusive")
    public @AssertTrue(message="'expression' and 'script' are mutually exclusive") boolean isExpressionOrScriptValid() {
        return this.script == null || this.expression == DEFAULT_EXPRESSION;
    }
}

