/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.app.rabbit.sink;

import javax.validation.constraints.AssertTrue;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.expression.Expression;
import org.springframework.validation.annotation.Validated;

@ConfigurationProperties(value="rabbit")
@Validated
public class RabbitSinkProperties {
    public static final String JSON_CONVERTER = "jsonConverter";
    private String exchange = "";
    private Expression exchangeExpression;
    private String routingKey;
    private Expression routingKeyExpression;
    private boolean persistentDeliveryMode;
    private String[] mappedRequestHeaders = new String[]{"*"};
    private String converterBeanName;
    private boolean ownConnection;

    public String getExchange() {
        return this.exchange;
    }

    public void setExchange(String exchange) {
        this.exchange = exchange;
    }

    public Expression getExchangeExpression() {
        return this.exchangeExpression;
    }

    public void setExchangeExpression(Expression exchangeExpression) {
        this.exchangeExpression = exchangeExpression;
    }

    public String getRoutingKey() {
        return this.routingKey;
    }

    public void setRoutingKey(String routingKey) {
        this.routingKey = routingKey;
    }

    public Expression getRoutingKeyExpression() {
        return this.routingKeyExpression;
    }

    public void setRoutingKeyExpression(Expression routingKeyExpression) {
        this.routingKeyExpression = routingKeyExpression;
    }

    public boolean getPersistentDeliveryMode() {
        return this.persistentDeliveryMode;
    }

    public void setPersistentDeliveryMode(boolean persistentDeliveryMode) {
        this.persistentDeliveryMode = persistentDeliveryMode;
    }

    public String[] getMappedRequestHeaders() {
        return this.mappedRequestHeaders;
    }

    public void setMappedRequestHeaders(String[] mappedRequestHeaders) {
        this.mappedRequestHeaders = mappedRequestHeaders;
    }

    public String getConverterBeanName() {
        return this.converterBeanName;
    }

    public void setConverterBeanName(String converterBeanName) {
        this.converterBeanName = converterBeanName;
    }

    @AssertTrue(message="routingKey or routingKeyExpression is required")
    public @AssertTrue(message="routingKey or routingKeyExpression is required") boolean isRoutingKeyProvided() {
        return this.routingKey != null || this.routingKeyExpression != null;
    }

    public boolean isOwnConnection() {
        return this.ownConnection;
    }

    public void setOwnConnection(boolean ownConnection) {
        this.ownConnection = ownConnection;
    }
}

