/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.app.log.sink;

import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.stream.annotation.EnableBinding;
import org.springframework.cloud.stream.app.log.sink.LogSinkProperties;
import org.springframework.cloud.stream.config.BindingProperties;
import org.springframework.cloud.stream.messaging.Sink;
import org.springframework.context.annotation.Bean;
import org.springframework.integration.annotation.ServiceActivator;
import org.springframework.integration.handler.LoggingHandler;
import org.springframework.integration.support.MutableMessage;
import org.springframework.messaging.Message;

@EnableBinding(value={Sink.class})
@EnableConfigurationProperties(value={LogSinkProperties.class})
public class LogSinkConfiguration {
    @Autowired
    private LogSinkProperties properties;

    @Bean
    @ServiceActivator(inputChannel="input")
    public LoggingHandler logSinkHandler() {
        LoggingHandler loggingHandler = new LoggingHandler(this.properties.getLevel().name()){

            protected void handleMessageInternal(Message<?> message) throws Exception {
                if (message.getPayload() instanceof byte[]) {
                    String contentType;
                    String string = contentType = message.getHeaders().containsKey((Object)"contentType") ? message.getHeaders().get((Object)"contentType").toString() : BindingProperties.DEFAULT_CONTENT_TYPE.toString();
                    if (contentType.contains("text") || contentType.contains("json") || contentType.contains("x-spring-tuple")) {
                        message = new MutableMessage((Object)new String((byte[])message.getPayload()), (Map)message.getHeaders());
                    }
                }
                super.handleMessageInternal(message);
            }
        };
        loggingHandler.setLogExpressionString(this.properties.getExpression());
        loggingHandler.setLoggerName(this.properties.getName());
        return loggingHandler;
    }
}

