/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.app.jdbc.sink;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.DirectFieldAccessor;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationPropertiesBinding;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.stream.annotation.EnableBinding;
import org.springframework.cloud.stream.app.jdbc.sink.DefaultInitializationScriptResource;
import org.springframework.cloud.stream.app.jdbc.sink.JdbcSinkProperties;
import org.springframework.cloud.stream.app.jdbc.sink.ShorthandMapConverter;
import org.springframework.cloud.stream.messaging.Sink;
import org.springframework.context.annotation.Bean;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.integration.annotation.ServiceActivator;
import org.springframework.integration.expression.ExpressionUtils;
import org.springframework.integration.jdbc.JdbcMessageHandler;
import org.springframework.integration.jdbc.SqlParameterSourceFactory;
import org.springframework.integration.json.JsonPropertyAccessor;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.datasource.init.DataSourceInitializer;
import org.springframework.jdbc.datasource.init.DatabasePopulator;
import org.springframework.jdbc.datasource.init.ResourceDatabasePopulator;
import org.springframework.messaging.Message;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

@EnableBinding(value={Sink.class})
@EnableConfigurationProperties(value={JdbcSinkProperties.class})
public class JdbcSinkConfiguration {
    private static final Log logger = LogFactory.getLog(JdbcSinkConfiguration.class);
    public static final Object NOT_SET = new Object();
    private SpelExpressionParser spelExpressionParser = new SpelExpressionParser();
    @Autowired
    private BeanFactory beanFactory;
    protected EvaluationContext evaluationContext;
    @Autowired
    private JdbcSinkProperties properties;

    @Bean
    @ServiceActivator(autoStartup="true", inputChannel="input")
    public JdbcMessageHandler jdbcMessageHandler(DataSource dataSource) {
        LinkedMultiValueMap columnExpressionVariations = new LinkedMultiValueMap();
        for (Map.Entry<String, String> entry : this.properties.getColumns().entrySet()) {
            String value = entry.getValue();
            columnExpressionVariations.add((Object)entry.getKey(), (Object)this.spelExpressionParser.parseExpression(value));
            if (value.startsWith("payload")) continue;
            columnExpressionVariations.add((Object)entry.getKey(), (Object)this.spelExpressionParser.parseExpression("payload." + value));
        }
        JdbcMessageHandler jdbcMessageHandler = new JdbcMessageHandler(dataSource, this.generateSql(this.properties.getTableName(), columnExpressionVariations.keySet()));
        jdbcMessageHandler.setSqlParameterSourceFactory(new SqlParameterSourceFactory((MultiValueMap)columnExpressionVariations){
            final /* synthetic */ MultiValueMap val$columnExpressionVariations;
            {
                this.val$columnExpressionVariations = multiValueMap;
            }

            public SqlParameterSource createParameterSource(Object o) {
                if (!(o instanceof Message)) {
                    throw new IllegalArgumentException("Unable to handle type " + o.getClass().getName());
                }
                Message message = (Message)o;
                MapSqlParameterSource parameterSource = new MapSqlParameterSource();
                for (String key : this.val$columnExpressionVariations.keySet()) {
                    List spels = (List)this.val$columnExpressionVariations.get((Object)key);
                    Object value = NOT_SET;
                    EvaluationException lastException = null;
                    for (Expression spel : spels) {
                        try {
                            value = spel.getValue(JdbcSinkConfiguration.this.evaluationContext, (Object)message);
                            break;
                        }
                        catch (EvaluationException e) {
                            lastException = e;
                        }
                    }
                    if (value == NOT_SET) {
                        if (lastException != null) {
                            logger.info((Object)("Could not find value for column '" + key + "': " + lastException.getMessage()));
                        }
                        parameterSource.addValue(key, null);
                        continue;
                    }
                    if (value instanceof JsonPropertyAccessor.ToStringFriendlyJsonNode) {
                        DirectFieldAccessor dfa = new DirectFieldAccessor(value);
                        JsonNode node = (JsonNode)dfa.getPropertyValue("node");
                        Object valueToUse = node == null || node.isNull() ? null : (node.isNumber() ? node.numberValue() : (node.isBoolean() ? Boolean.valueOf(node.booleanValue()) : node.textValue()));
                        parameterSource.addValue(key, valueToUse);
                        continue;
                    }
                    parameterSource.addValue(key, value);
                }
                return parameterSource;
            }
        });
        return jdbcMessageHandler;
    }

    @ConditionalOnProperty(value={"jdbc.initialize"})
    @Bean
    public DataSourceInitializer nonBootDataSourceInitializer(DataSource dataSource, ResourceLoader resourceLoader) {
        DataSourceInitializer dataSourceInitializer = new DataSourceInitializer();
        dataSourceInitializer.setDataSource(dataSource);
        ResourceDatabasePopulator databasePopulator = new ResourceDatabasePopulator();
        databasePopulator.setIgnoreFailedDrops(true);
        dataSourceInitializer.setDatabasePopulator((DatabasePopulator)databasePopulator);
        if ("true".equals(this.properties.getInitialize())) {
            databasePopulator.addScript((Resource)new DefaultInitializationScriptResource(this.properties));
        } else {
            databasePopulator.addScript(resourceLoader.getResource(this.properties.getInitialize()));
        }
        return dataSourceInitializer;
    }

    @PostConstruct
    public void afterPropertiesSet() {
        this.evaluationContext = ExpressionUtils.createStandardEvaluationContext((BeanFactory)this.beanFactory);
    }

    private String generateSql(String tableName, Set<String> columns) {
        StringBuilder builder = new StringBuilder("INSERT INTO ");
        StringBuilder questionMarks = new StringBuilder(") VALUES (");
        builder.append(tableName).append("(");
        int i = 0;
        for (String column : columns) {
            if (i++ > 0) {
                builder.append(", ");
                questionMarks.append(", ");
            }
            builder.append(column);
            questionMarks.append(':' + column);
        }
        builder.append((CharSequence)questionMarks).append(")");
        return builder.toString();
    }

    public static class Nested {
        @Bean
        @ConfigurationPropertiesBinding
        public ShorthandMapConverter shorthandMapConverter() {
            return new ShorthandMapConverter();
        }
    }
}

