/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.app.jdbc.sink;

import java.nio.charset.Charset;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.stream.app.jdbc.sink.JdbcSinkProperties;
import org.springframework.core.io.ByteArrayResource;

public class DefaultInitializationScriptResource
extends ByteArrayResource {
    private static final Log logger = LogFactory.getLog(DefaultInitializationScriptResource.class);

    public DefaultInitializationScriptResource(JdbcSinkProperties properties) {
        super(DefaultInitializationScriptResource.scriptFor(properties).getBytes(Charset.forName("UTF-8")));
    }

    private static String scriptFor(JdbcSinkProperties properties) {
        StringBuilder result = new StringBuilder("DROP TABLE ");
        result.append(properties.getTableName()).append(";\n\n");
        result.append("CREATE TABLE ").append(properties.getTableName()).append('(');
        int i = 0;
        for (String column : properties.getColumns().keySet()) {
            if (i++ > 0) {
                result.append(", ");
            }
            result.append(column).append(" VARCHAR(2000)");
        }
        result.append(");\n");
        logger.debug((Object)String.format("Generated the following initializing script for table %s:\n%s", properties.getTableName(), result.toString()));
        return result.toString();
    }
}

