/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.app.hdfs.sink;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.cloud.stream.app.hdfs.hadoop.store.DataStoreWriter;
import org.springframework.cloud.stream.app.hdfs.hadoop.store.codec.CodecInfo;
import org.springframework.cloud.stream.app.hdfs.hadoop.store.codec.Codecs;
import org.springframework.cloud.stream.app.hdfs.hadoop.store.output.PartitionTextFileWriter;
import org.springframework.cloud.stream.app.hdfs.hadoop.store.output.TextFileWriter;
import org.springframework.cloud.stream.app.hdfs.hadoop.store.partition.MessagePartitionStrategy;
import org.springframework.cloud.stream.app.hdfs.hadoop.store.partition.PartitionStrategy;
import org.springframework.cloud.stream.app.hdfs.hadoop.store.strategy.naming.ChainedFileNamingStrategy;
import org.springframework.cloud.stream.app.hdfs.hadoop.store.strategy.naming.CodecFileNamingStrategy;
import org.springframework.cloud.stream.app.hdfs.hadoop.store.strategy.naming.FileNamingStrategy;
import org.springframework.cloud.stream.app.hdfs.hadoop.store.strategy.naming.FileNamingStrategyFactory;
import org.springframework.cloud.stream.app.hdfs.hadoop.store.strategy.naming.RollingFileNamingStrategy;
import org.springframework.cloud.stream.app.hdfs.hadoop.store.strategy.naming.StaticFileNamingStrategy;
import org.springframework.cloud.stream.app.hdfs.hadoop.store.strategy.naming.UuidFileNamingStrategy;
import org.springframework.cloud.stream.app.hdfs.hadoop.store.strategy.rollover.RolloverStrategy;
import org.springframework.cloud.stream.app.hdfs.hadoop.store.strategy.rollover.RolloverStrategyFactory;
import org.springframework.cloud.stream.app.hdfs.hadoop.store.strategy.rollover.SizeRolloverStrategy;
import org.springframework.cloud.stream.app.hdfs.sink.HdfsSinkProperties;
import org.springframework.context.Lifecycle;
import org.springframework.context.SmartLifecycle;
import org.springframework.core.task.TaskExecutor;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.integration.context.IntegrationContextUtils;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.util.StringUtils;

public class DataStoreWriterFactoryBean
implements InitializingBean,
DisposableBean,
FactoryBean<DataStoreWriter<String>>,
BeanFactoryAware,
SmartLifecycle {
    private HdfsSinkProperties properties;
    private volatile DataStoreWriter<String> storeWriter;
    private volatile Configuration configuration;
    private volatile BeanFactory beanFactory;
    private TaskScheduler taskScheduler;
    private TaskExecutor taskExecutor;
    private volatile int phase;
    private volatile boolean autoStartup = true;

    public void destroy() throws Exception {
        this.storeWriter = null;
    }

    public DataStoreWriter<String> getObject() throws Exception {
        return this.storeWriter;
    }

    public Class<?> getObjectType() {
        return DataStoreWriter.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        Configuration configurationToUse = null;
        if (StringUtils.hasText((String)this.properties.getFsUri())) {
            configurationToUse = new Configuration(this.configuration);
            configurationToUse.set("fs.defaultFS", this.properties.getFsUri());
        } else {
            configurationToUse = this.configuration;
        }
        StandardEvaluationContext evaluationContext = IntegrationContextUtils.getEvaluationContext((BeanFactory)this.beanFactory);
        CodecInfo codec = null;
        if (this.properties.getCodec() != null) {
            codec = Codecs.getCodecInfo((String)this.properties.getCodec());
        }
        ArrayList<Object> strategies = new ArrayList<Object>();
        strategies.add(new StaticFileNamingStrategy(this.properties.getFileName()));
        if (this.properties.isFileUuid()) {
            strategies.add(new UuidFileNamingStrategy());
        }
        strategies.add(new RollingFileNamingStrategy());
        strategies.add(new StaticFileNamingStrategy(this.properties.getFileExtension(), "."));
        if (codec != null) {
            strategies.add(new CodecFileNamingStrategy());
        }
        ChainedFileNamingStrategy fileNamingStrategy = new ChainedFileNamingStrategy();
        fileNamingStrategy.setStrategies(strategies);
        SizeRolloverStrategy rolloverStrategy = new SizeRolloverStrategy((long)this.properties.getRollover());
        String partitionExpression = null;
        if (StringUtils.hasText((String)this.properties.getPartitionPath())) {
            partitionExpression = this.properties.getPartitionPath();
        }
        Path basePath = new Path(this.properties.getDirectory());
        if (StringUtils.isEmpty((Object)partitionExpression)) {
            TextFileWriter writer = new TextFileWriter(configurationToUse, basePath, codec);
            writer.setIdleTimeout(this.properties.getIdleTimeout());
            writer.setCloseTimeout(this.properties.getCloseTimeout());
            writer.setSyncable(this.properties.isEnableSync());
            writer.setFlushTimeout(this.properties.getFlushTimeout());
            if (StringUtils.hasText((String)this.properties.getInUsePrefix())) {
                writer.setInWritingPrefix(this.properties.getInUsePrefix());
            }
            if (StringUtils.hasText((String)this.properties.getInUseSuffix())) {
                writer.setInWritingSuffix(this.properties.getInUseSuffix());
            }
            writer.setOverwrite(this.properties.isOverwrite());
            writer.setFileNamingStrategy((FileNamingStrategy)fileNamingStrategy);
            writer.setRolloverStrategy((RolloverStrategy)rolloverStrategy);
            if (this.beanFactory != null) {
                writer.setBeanFactory(this.beanFactory);
            }
            if (this.properties.getFileOpenAttempts() > 0) {
                writer.setMaxOpenAttempts(this.properties.getFileOpenAttempts());
            }
            writer.setTaskExecutor(this.taskExecutor);
            writer.setTaskScheduler(this.taskScheduler);
            this.storeWriter = writer;
        } else {
            if (!(evaluationContext instanceof StandardEvaluationContext)) {
                throw new RuntimeException("Expecting evaluationContext of type StandardEvaluationContext but was " + evaluationContext);
            }
            MessagePartitionStrategy partitionStrategy = new MessagePartitionStrategy(partitionExpression, evaluationContext);
            PartitionTextFileWriter writer = new PartitionTextFileWriter(configurationToUse, basePath, codec, (PartitionStrategy)partitionStrategy);
            writer.setIdleTimeout(this.properties.getIdleTimeout());
            writer.setCloseTimeout(this.properties.getCloseTimeout());
            writer.setSyncable(this.properties.isEnableSync());
            writer.setFlushTimeout(this.properties.getFlushTimeout());
            if (StringUtils.hasText((String)this.properties.getInUsePrefix())) {
                writer.setInWritingPrefix(this.properties.getInUsePrefix());
            }
            if (StringUtils.hasText((String)this.properties.getInUseSuffix())) {
                writer.setInWritingSuffix(this.properties.getInUseSuffix());
            }
            writer.setOverwrite(this.properties.isOverwrite());
            writer.setFileNamingStrategyFactory((FileNamingStrategyFactory)fileNamingStrategy);
            writer.setRolloverStrategyFactory((RolloverStrategyFactory)rolloverStrategy);
            if (this.beanFactory != null) {
                writer.setBeanFactory(this.beanFactory);
            }
            if (this.properties.getFileOpenAttempts() > 0) {
                writer.setMaxOpenAttempts(this.properties.getFileOpenAttempts());
            }
            writer.setTaskExecutor(this.taskExecutor);
            writer.setTaskScheduler(this.taskScheduler);
            this.storeWriter = writer;
        }
        if (this.storeWriter instanceof InitializingBean) {
            ((InitializingBean)this.storeWriter).afterPropertiesSet();
        }
    }

    @Autowired
    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    @Autowired
    public void setProperties(HdfsSinkProperties properties) {
        this.properties = properties;
    }

    @Autowired
    public void setTaskScheduler(@Qualifier(value="hdfsSinkTaskScheduler") TaskScheduler taskScheduler) {
        this.taskScheduler = taskScheduler;
    }

    @Autowired
    public void setTaskExecutor(@Qualifier(value="TASK_EXECUTOR_BEAN") TaskExecutor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    public void setPhase(int phase) {
        this.phase = phase;
    }

    public void setAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void start() {
        if (this.storeWriter instanceof Lifecycle) {
            ((Lifecycle)this.storeWriter).start();
        }
    }

    public void stop() {
        try {
            this.storeWriter.close();
        }
        catch (IOException e) {
            throw new IllegalStateException("Error while closing StoreWriter", e);
        }
        if (this.storeWriter instanceof Lifecycle) {
            ((Lifecycle)this.storeWriter).stop();
        }
    }

    public boolean isRunning() {
        if (this.storeWriter instanceof Lifecycle) {
            return ((Lifecycle)this.storeWriter).isRunning();
        }
        return false;
    }

    public boolean isAutoStartup() {
        return this.autoStartup;
    }

    public void stop(Runnable runnable) {
        this.stop();
        if (runnable != null) {
            runnable.run();
        }
    }

    public int getPhase() {
        return this.phase;
    }
}

