/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.app.gpfdist.sink.support;

import java.util.List;
import org.springframework.cloud.stream.app.gpfdist.sink.support.Format;
import org.springframework.cloud.stream.app.gpfdist.sink.support.LoadConfiguration;
import org.springframework.cloud.stream.app.gpfdist.sink.support.Mode;
import org.springframework.cloud.stream.app.gpfdist.sink.support.ReadableTable;
import org.springframework.util.StringUtils;

public abstract class SqlUtils {
    public static String createExternalReadableTable(LoadConfiguration config, String prefix, List<String> overrideLocations) {
        StringBuilder buf = new StringBuilder();
        String name = config.getTable() + "_ext_" + prefix;
        buf.append("CREATE READABLE EXTERNAL TABLE ");
        buf.append(name);
        buf.append(" ( ");
        ReadableTable externalTable = config.getExternalTable();
        if (externalTable.getLike() != null) {
            buf.append("LIKE ");
            buf.append(config.getTable());
        } else if (StringUtils.hasText((String)externalTable.getColumns())) {
            buf.append(externalTable.getColumns());
        } else {
            buf.append("LIKE ");
            buf.append(config.getTable());
        }
        buf.append(" ) ");
        buf.append("LOCATION(");
        if (overrideLocations != null && !overrideLocations.isEmpty()) {
            buf.append(SqlUtils.createLocationString(overrideLocations.toArray(new String[0])));
        } else {
            buf.append(SqlUtils.createLocationString(externalTable.getLocations().toArray(new String[0])));
        }
        buf.append(") ");
        if (externalTable.getFormat() == Format.TEXT) {
            buf.append("FORMAT 'TEXT'");
        } else {
            buf.append("FORMAT 'CSV'");
        }
        buf.append(" ( ");
        buf.append("DELIMITER '");
        if (externalTable.getDelimiter() != null) {
            buf.append(SqlUtils.unicodeEscaped(externalTable.getDelimiter().charValue()));
        } else {
            buf.append("|");
        }
        buf.append("'");
        if (externalTable.getNullString() != null) {
            buf.append(" NULL '");
            buf.append(externalTable.getNullString());
            buf.append("'");
        }
        if (externalTable.getEscape() != null) {
            buf.append(" ESCAPE '");
            buf.append(externalTable.getEscape());
            buf.append("'");
        }
        if (externalTable.getQuote() != null) {
            buf.append(" QUOTE '");
            buf.append(externalTable.getQuote());
            buf.append("'");
        }
        if (externalTable.getForceQuote() != null) {
            buf.append(" FORCE QUOTE ");
            buf.append(StringUtils.arrayToCommaDelimitedString((Object[])externalTable.getForceQuote()));
        }
        buf.append(" )");
        if (externalTable.getEncoding() != null) {
            buf.append(" ENCODING '");
            buf.append(externalTable.getEncoding());
            buf.append("'");
        }
        if (externalTable.getSegmentRejectLimit() != null && externalTable.getSegmentRejectType() != null) {
            if (externalTable.isLogErrors()) {
                buf.append(" LOG ERRORS");
            }
            buf.append(" SEGMENT REJECT LIMIT ");
            buf.append(externalTable.getSegmentRejectLimit());
            buf.append(" ");
            buf.append((Object)externalTable.getSegmentRejectType());
        }
        return buf.toString();
    }

    public static String dropExternalReadableTable(LoadConfiguration config, String prefix) {
        StringBuilder b = new StringBuilder();
        String name = config.getTable() + "_ext_" + prefix;
        b.append("DROP EXTERNAL TABLE ");
        b.append(name);
        return b.toString();
    }

    public static String load(LoadConfiguration config, String prefix) {
        if (config.getMode() == Mode.INSERT) {
            return SqlUtils.loadInsert(config, prefix);
        }
        if (config.getMode() == Mode.UPDATE) {
            return SqlUtils.loadUpdate(config, prefix);
        }
        throw new IllegalArgumentException("Unsupported mode " + (Object)((Object)config.getMode()));
    }

    private static String loadInsert(LoadConfiguration config, String prefix) {
        StringBuilder b = new StringBuilder();
        String name = config.getTable() + "_ext_" + prefix;
        b.append("INSERT INTO ");
        b.append(config.getTable());
        b.append(" SELECT ");
        if (StringUtils.hasText((String)config.getColumns())) {
            b.append(config.getColumns());
        } else {
            b.append("*");
        }
        b.append(" FROM ");
        b.append(name);
        return b.toString();
    }

    private static String loadUpdate(LoadConfiguration config, String prefix) {
        int i;
        StringBuilder b = new StringBuilder();
        String name = config.getTable() + "_ext_" + prefix;
        b.append("UPDATE ");
        b.append(config.getTable());
        b.append(" into_table set ");
        for (i = 0; i < config.getUpdateColumns().size(); ++i) {
            b.append(config.getUpdateColumns().get(i) + "=from_table." + config.getUpdateColumns().get(i));
            if (i + 1 >= config.getUpdateColumns().size()) continue;
            b.append(", ");
        }
        b.append(" FROM ");
        b.append(name);
        b.append(" from_table where ");
        for (i = 0; i < config.getMatchColumns().size(); ++i) {
            b.append("into_table." + config.getMatchColumns().get(i) + "=from_table." + config.getMatchColumns().get(i));
            if (i + 1 >= config.getMatchColumns().size()) continue;
            b.append(" and ");
        }
        if (StringUtils.hasText((String)config.getUpdateCondition())) {
            b.append(" and " + config.getUpdateCondition());
        }
        return b.toString();
    }

    public static String createLocationString(String[] strings) {
        StringBuilder locString = new StringBuilder();
        for (int i = 0; i < strings.length; ++i) {
            String string = strings[i];
            locString.append("'");
            locString.append(string);
            locString.append("'");
            if (i >= strings.length - 1) continue;
            locString.append(",");
        }
        return locString.toString();
    }

    private static String unicodeEscaped(char ch) {
        if (ch < '\u0010') {
            return "\\u000" + Integer.toHexString(ch);
        }
        if (ch < '\u0100') {
            return "\\u00" + Integer.toHexString(ch);
        }
        if (ch < '\u1000') {
            return "\\u0" + Integer.toHexString(ch);
        }
        return "\\u" + Integer.toHexString(ch);
    }
}

