/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.app.gpfdist.sink;

import java.util.ArrayList;
import java.util.Arrays;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.stream.annotation.EnableBinding;
import org.springframework.cloud.stream.app.gpfdist.sink.GpfdistMessageHandler;
import org.springframework.cloud.stream.app.gpfdist.sink.GpfdistSinkProperties;
import org.springframework.cloud.stream.app.gpfdist.sink.HostInfoDiscoveryProperties;
import org.springframework.cloud.stream.app.gpfdist.sink.support.ControlFile;
import org.springframework.cloud.stream.app.gpfdist.sink.support.ControlFileFactoryBean;
import org.springframework.cloud.stream.app.gpfdist.sink.support.GreenplumDataSourceFactoryBean;
import org.springframework.cloud.stream.app.gpfdist.sink.support.GreenplumLoad;
import org.springframework.cloud.stream.app.gpfdist.sink.support.LoadConfiguration;
import org.springframework.cloud.stream.app.gpfdist.sink.support.LoadConfigurationFactoryBean;
import org.springframework.cloud.stream.app.gpfdist.sink.support.LoadFactoryBean;
import org.springframework.cloud.stream.app.gpfdist.sink.support.Mode;
import org.springframework.cloud.stream.app.gpfdist.sink.support.NetworkUtils;
import org.springframework.cloud.stream.app.gpfdist.sink.support.ReadableTable;
import org.springframework.cloud.stream.app.gpfdist.sink.support.ReadableTableFactoryBean;
import org.springframework.cloud.stream.messaging.Sink;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.hadoop.util.net.DefaultHostInfoDiscovery;
import org.springframework.data.hadoop.util.net.HostInfoDiscovery;
import org.springframework.integration.annotation.ServiceActivator;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.util.StringUtils;

@Configuration
@EnableConfigurationProperties(value={GpfdistSinkProperties.class, HostInfoDiscoveryProperties.class})
@EnableBinding(value={Sink.class})
public class GpfdistSinkConfiguration {
    @Autowired
    private GpfdistSinkProperties properties;
    @Autowired
    private HostInfoDiscoveryProperties discoveryProperties;

    @Bean
    public HostInfoDiscovery hostInfoDiscovery() {
        DefaultHostInfoDiscovery discovery = new DefaultHostInfoDiscovery();
        if (StringUtils.hasText((String)this.discoveryProperties.getMatchIpv4())) {
            discovery.setMatchIpv4(this.discoveryProperties.getMatchIpv4());
        }
        if (StringUtils.hasText((String)this.discoveryProperties.getMatchInterface())) {
            discovery.setMatchInterface(this.discoveryProperties.getMatchInterface());
        }
        if (this.discoveryProperties.getPreferInterface() != null) {
            discovery.setPreferInterface(this.discoveryProperties.getPreferInterface());
        }
        discovery.setLoopback(this.discoveryProperties.isLoopback());
        discovery.setPointToPoint(this.discoveryProperties.isPointToPoint());
        return discovery;
    }

    @Bean
    public TaskScheduler sqlTaskScheduler() {
        ThreadPoolTaskScheduler taskScheduler = new ThreadPoolTaskScheduler();
        taskScheduler.setWaitForTasksToCompleteOnShutdown(true);
        taskScheduler.setAwaitTerminationSeconds(this.properties.getBatchTimeout());
        return taskScheduler;
    }

    @Bean
    public ControlFileFactoryBean greenplumControlFile() {
        ControlFileFactoryBean factoryBean = new ControlFileFactoryBean();
        factoryBean.setControlFileResource(this.properties.getControlFile());
        return factoryBean;
    }

    @Bean
    public GreenplumDataSourceFactoryBean dataSource(ControlFile controlFile) {
        GreenplumDataSourceFactoryBean factoryBean = new GreenplumDataSourceFactoryBean();
        factoryBean.setControlFile(controlFile);
        factoryBean.setDbHost(this.properties.getDbHost());
        factoryBean.setDbName(this.properties.getDbName());
        factoryBean.setDbUser(this.properties.getDbUser());
        factoryBean.setDbPassword(this.properties.getDbPassword());
        factoryBean.setDbPort(this.properties.getDbPort());
        return factoryBean;
    }

    @Bean
    public ReadableTableFactoryBean greenplumReadableTable(ControlFile controlFile, HostInfoDiscovery hostInfoDiscovery) {
        ReadableTableFactoryBean factoryBean = new ReadableTableFactoryBean();
        factoryBean.setControlFile(controlFile);
        factoryBean.setDelimiter(this.properties.getColumnDelimiter());
        factoryBean.setLogErrors(this.properties.isLogErrors());
        factoryBean.setSegmentReject(this.properties.getSegmentRejectLimit());
        factoryBean.setSegmentRejectType(this.properties.getSegmentRejectType());
        factoryBean.setNullString(this.properties.getNullString());
        HostInfoDiscovery.HostInfo hostInfo = hostInfoDiscovery.getHostInfo();
        factoryBean.setLocations(Arrays.asList(NetworkUtils.getGPFDistUri(hostInfo.getAddress(), this.properties.getGpfdistPort())));
        return factoryBean;
    }

    @Bean
    public LoadConfigurationFactoryBean greenplumLoadConfiguration(ReadableTable externalTable, ControlFile controlFile) {
        LoadConfigurationFactoryBean factoryBean = new LoadConfigurationFactoryBean();
        factoryBean.setExternalTable(externalTable);
        factoryBean.setControlFile(controlFile);
        factoryBean.setMode(StringUtils.hasText((String)this.properties.getMode()) ? Mode.valueOf(this.properties.getMode().toUpperCase()) : Mode.INSERT);
        factoryBean.setUpdateColumns(StringUtils.commaDelimitedListToStringArray((String)this.properties.getUpdateColumns()));
        factoryBean.setMatchColumns(StringUtils.commaDelimitedListToStringArray((String)this.properties.getMatchColumns()));
        factoryBean.setTable(this.properties.getTable());
        factoryBean.setSqlBefore(StringUtils.hasText((String)this.properties.getSqlBefore()) ? Arrays.asList(this.properties.getSqlBefore()) : new ArrayList<String>());
        factoryBean.setSqlAfter(StringUtils.hasText((String)this.properties.getSqlAfter()) ? Arrays.asList(this.properties.getSqlAfter()) : new ArrayList<String>());
        return factoryBean;
    }

    @Bean
    public LoadFactoryBean greenplumLoad(LoadConfiguration loadConfiguration, DataSource dataSource) {
        LoadFactoryBean factoryBean = new LoadFactoryBean();
        factoryBean.setLoadConfiguration(loadConfiguration);
        factoryBean.setDataSource(dataSource);
        return factoryBean;
    }

    @Bean
    @ServiceActivator(inputChannel="input")
    public GpfdistMessageHandler gpfdist(GreenplumLoad greenplumLoad, TaskScheduler sqlTaskScheduler, HostInfoDiscovery hostInfoDiscovery) {
        GpfdistMessageHandler handler = new GpfdistMessageHandler(this.properties.getGpfdistPort(), this.properties.getFlushCount(), this.properties.getFlushTime(), this.properties.getBatchTimeout(), this.properties.getBatchCount(), this.properties.getBatchPeriod(), this.properties.getDelimiter(), hostInfoDiscovery);
        handler.setRateInterval(this.properties.getRateInterval());
        handler.setGreenplumLoad(greenplumLoad);
        handler.setSqlTaskScheduler(sqlTaskScheduler);
        return handler;
    }
}

