/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.app.gpfdist.sink.support;

import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.cloud.stream.app.gpfdist.sink.support.ControlFile;
import org.springframework.cloud.stream.app.gpfdist.sink.support.Format;
import org.springframework.cloud.stream.app.gpfdist.sink.support.ReadableTable;
import org.springframework.cloud.stream.app.gpfdist.sink.support.SegmentRejectType;
import org.springframework.util.StringUtils;

public class ReadableTableFactoryBean
implements FactoryBean<ReadableTable>,
InitializingBean {
    private ControlFile controlFile;
    private List<String> locations;
    private String columns;
    private String like;
    private boolean keeptable;
    private Format format = Format.TEXT;
    private Character delimiter;
    private String nullString;
    private Character escape;
    private Character quote;
    private String[] forceQuote;
    private boolean logErrors;
    private Integer segmentRejectLimit;
    private SegmentRejectType segmentRejectType;

    public void afterPropertiesSet() throws Exception {
        if (this.controlFile != null && this.controlFile.getGploadInputDelimiter() != null) {
            this.delimiter = this.controlFile.getGploadInputDelimiter();
        }
    }

    public ReadableTable getObject() throws Exception {
        ReadableTable w = new ReadableTable();
        w.setLocations(this.locations);
        w.setColumns(this.columns);
        w.setLike(this.like);
        w.setLogErrors(this.logErrors);
        if (this.segmentRejectLimit != null && this.segmentRejectLimit > 0) {
            w.setSegmentRejectLimit(this.segmentRejectLimit);
        }
        w.setSegmentRejectType(this.segmentRejectType);
        if (this.format == Format.TEXT) {
            Character delim = this.delimiter != null ? this.delimiter : Character.valueOf('\t');
            w.setTextFormat(delim, this.nullString, this.escape);
        } else if (this.format == Format.CSV) {
            Character delim = this.delimiter != null ? this.delimiter : Character.valueOf(',');
            w.setCsvFormat(this.quote, delim, this.nullString, this.forceQuote, this.escape);
        }
        return w;
    }

    public Class<ReadableTable> getObjectType() {
        return ReadableTable.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setControlFile(ControlFile controlFile) {
        this.controlFile = controlFile;
    }

    public Integer getSegmentRejectLimit() {
        return this.segmentRejectLimit;
    }

    public void setSegmentRejectLimit(Integer segmentRejectLimit) {
        this.segmentRejectLimit = segmentRejectLimit;
    }

    public SegmentRejectType getSegmentRejectType() {
        return this.segmentRejectType;
    }

    public void setSegmentReject(String reject) {
        if (!StringUtils.hasText((String)reject)) {
            return;
        }
        Integer parsedLimit = null;
        try {
            parsedLimit = Integer.parseInt(reject);
            this.segmentRejectType = SegmentRejectType.ROWS;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (parsedLimit == null && reject.contains("%")) {
            try {
                parsedLimit = Integer.parseInt(reject.replace("%", "").trim());
                this.segmentRejectType = SegmentRejectType.PERCENT;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.segmentRejectLimit = parsedLimit;
    }

    public void setSegmentRejectType(SegmentRejectType segmentRejectType) {
        if (segmentRejectType != null) {
            this.segmentRejectType = segmentRejectType;
        }
    }

    public boolean isLogErrors() {
        return this.logErrors;
    }

    public void setLogErrors(boolean logErrors) {
        this.logErrors = logErrors;
    }

    public Character getQuote() {
        return this.quote;
    }

    public void setQuote(Character quote) {
        this.quote = quote;
    }

    public String[] getForceQuote() {
        return this.forceQuote;
    }

    public void setForceQuote(String[] forceQuote) {
        this.forceQuote = Arrays.copyOf(forceQuote, forceQuote.length);
    }

    public Character getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(Character delimiter) {
        this.delimiter = delimiter;
    }

    public String getNullString() {
        return this.nullString;
    }

    public void setNullString(String nullString) {
        this.nullString = nullString;
    }

    public Character getEscape() {
        return this.escape;
    }

    public void setEscape(Character escape) {
        this.escape = escape;
    }

    public List<String> getLocations() {
        return this.locations;
    }

    public void setLocations(List<String> locations) {
        this.locations = locations;
    }

    public String getColumns() {
        return this.columns;
    }

    public void setColumns(String columns) {
        this.columns = columns;
    }

    public String getLike() {
        return this.like;
    }

    public void setLike(String like) {
        this.like = like;
    }

    public boolean isKeeptable() {
        return this.keeptable;
    }

    public void setKeeptable(boolean keeptable) {
        this.keeptable = keeptable;
    }

    public Format getFormat() {
        return this.format;
    }

    public void setFormat(Format format) {
        this.format = format;
    }
}

