/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.app.gpfdist.sink.support;

import java.io.IOException;
import javax.sql.DataSource;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.cloud.stream.app.gpfdist.sink.support.DefaultGreenplumLoad;
import org.springframework.cloud.stream.app.gpfdist.sink.support.DefaultLoadService;
import org.springframework.cloud.stream.app.gpfdist.sink.support.GreenplumLoad;
import org.springframework.cloud.stream.app.gpfdist.sink.support.LoadConfiguration;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.util.Assert;

public class LoadFactoryBean
implements FactoryBean<GreenplumLoad>,
InitializingBean,
DisposableBean {
    private DataSource dataSource;
    private LoadConfiguration loadConfiguration;
    private JdbcTemplate jdbcTemplate;

    public GreenplumLoad getObject() throws Exception {
        return new DefaultGreenplumLoad(this.loadConfiguration, new DefaultLoadService(this.jdbcTemplate));
    }

    public Class<GreenplumLoad> getObjectType() {
        return GreenplumLoad.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws IOException {
        Assert.notNull((Object)this.dataSource, (String)"DataSource must not be null.");
        Assert.notNull((Object)this.loadConfiguration, (String)"Load configuration must not be null.");
        this.jdbcTemplate = new JdbcTemplate(this.dataSource);
    }

    public void destroy() {
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setLoadConfiguration(LoadConfiguration LoadConfiguration2) {
        this.loadConfiguration = LoadConfiguration2;
    }
}

