/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.app.gpfdist.sink.support;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.util.StringUtils;

public class JdbcCommands {
    private static final Log log = LogFactory.getLog(JdbcCommands.class);
    private JdbcTemplate jdbcTemplate;
    private List<String> beforeSqls;
    private List<String> afterSqls;
    private String prepareSql;
    private String runSql;
    private String cleanSql;
    private DataAccessException lastException;

    public JdbcCommands(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public void setPrepareSql(String sql) {
        this.prepareSql = sql;
    }

    public void setRunSql(String sql) {
        this.runSql = sql;
    }

    public void setCleanSql(String sql) {
        this.cleanSql = sql;
    }

    public void setBeforeSqls(List<String> beforeSqls) {
        this.beforeSqls = beforeSqls;
    }

    public void setAfterSqls(List<String> afterSqls) {
        this.afterSqls = afterSqls;
    }

    public boolean execute() {
        boolean succeed = true;
        try {
            succeed = this.prepare();
            if (succeed) {
                succeed = this.before();
            }
            if (succeed) {
                succeed = this.run();
            }
            if (succeed) {
                succeed = this.after();
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                this.clean();
            }
            catch (Exception exception) {}
        }
        return succeed;
    }

    public DataAccessException getLastException() {
        return this.lastException;
    }

    private boolean prepare() {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Executing prepare: " + this.prepareSql));
            }
            this.jdbcTemplate.execute(this.prepareSql);
        }
        catch (DataAccessException e) {
            log.error((Object)"Error during prepare sql", (Throwable)e);
            this.lastException = e;
            return false;
        }
        return true;
    }

    private boolean run() {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Executing run: " + this.runSql));
            }
            this.jdbcTemplate.execute(this.runSql);
        }
        catch (DataAccessException e) {
            log.error((Object)"Error during run sql", (Throwable)e);
            this.lastException = e;
            return false;
        }
        return true;
    }

    private boolean clean() {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Executing clean: " + this.cleanSql));
            }
            this.jdbcTemplate.execute(this.cleanSql);
        }
        catch (DataAccessException e) {
            log.error((Object)"Error during clean sql", (Throwable)e);
            this.lastException = e;
            return false;
        }
        return true;
    }

    private boolean before() {
        if (this.beforeSqls != null) {
            for (String sql : this.beforeSqls) {
                if (!StringUtils.hasText((String)sql)) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Executing before: " + sql));
                }
                try {
                    this.jdbcTemplate.execute(sql);
                }
                catch (DataAccessException e) {
                    this.lastException = e;
                    return false;
                }
            }
        }
        return true;
    }

    private boolean after() {
        if (this.afterSqls != null) {
            for (String sql : this.afterSqls) {
                if (!StringUtils.hasText((String)sql)) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Executing after: " + sql));
                }
                try {
                    this.jdbcTemplate.execute(sql);
                }
                catch (DataAccessException e) {
                    this.lastException = e;
                    return false;
                }
            }
        }
        return true;
    }
}

