/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.app.gpfdist.sink.support;

import java.util.UUID;
import org.springframework.cloud.stream.app.gpfdist.sink.support.JdbcCommands;
import org.springframework.cloud.stream.app.gpfdist.sink.support.LoadConfiguration;
import org.springframework.cloud.stream.app.gpfdist.sink.support.LoadService;
import org.springframework.cloud.stream.app.gpfdist.sink.support.RuntimeContext;
import org.springframework.cloud.stream.app.gpfdist.sink.support.SqlUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.util.Assert;

public class DefaultLoadService
implements LoadService {
    private final JdbcTemplate jdbcTemplate;

    public DefaultLoadService(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
        Assert.notNull((Object)jdbcTemplate, (String)"JdbcTemplate must be set");
    }

    @Override
    public void load(LoadConfiguration loadConfiguration) {
        this.load(loadConfiguration, null);
    }

    @Override
    public void load(LoadConfiguration loadConfiguration, RuntimeContext context) {
        String prefix = UUID.randomUUID().toString().replaceAll("-", "_");
        JdbcCommands operations = new JdbcCommands(this.jdbcTemplate);
        String sqlCreateTable = SqlUtils.createExternalReadableTable(loadConfiguration, prefix, context != null ? context.getLocations() : null);
        String sqlDropTable = SqlUtils.dropExternalReadableTable(loadConfiguration, prefix);
        String sqlInsert = SqlUtils.load(loadConfiguration, prefix);
        operations.setPrepareSql(sqlCreateTable);
        operations.setCleanSql(sqlDropTable);
        operations.setRunSql(sqlInsert);
        operations.setBeforeSqls(loadConfiguration.getSqlBefore());
        operations.setAfterSqls(loadConfiguration.getSqlAfter());
        if (!operations.execute() && operations.getLastException() != null) {
            throw operations.getLastException();
        }
    }
}

