/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.app.gpfdist.sink.support;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.stream.app.gpfdist.sink.support.GreenplumLoad;
import org.springframework.cloud.stream.app.gpfdist.sink.support.LoadConfiguration;
import org.springframework.cloud.stream.app.gpfdist.sink.support.LoadService;
import org.springframework.cloud.stream.app.gpfdist.sink.support.RuntimeContext;
import org.springframework.util.Assert;

public class DefaultGreenplumLoad
implements GreenplumLoad {
    private static final Log log = LogFactory.getLog(DefaultGreenplumLoad.class);
    private final LoadService loadService;
    private final LoadConfiguration loadConfiguration;

    public DefaultGreenplumLoad(LoadConfiguration loadConfiguration, LoadService loadService) {
        this.loadConfiguration = loadConfiguration;
        this.loadService = loadService;
        Assert.notNull((Object)loadConfiguration, (String)"Load configuration must be set");
        Assert.notNull((Object)loadService, (String)"Load service must be set");
    }

    @Override
    public void load() {
        this.load(null);
    }

    @Override
    public void load(RuntimeContext context) {
        log.debug((Object)"Doing greenplum load");
        this.loadService.load(this.loadConfiguration, context);
    }
}

