/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.app.ftp.sink;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.expression.Expression;
import org.springframework.integration.file.support.FileExistsMode;
import org.springframework.validation.annotation.Validated;

@ConfigurationProperties(value="ftp")
@Validated
public class FtpSinkProperties {
    private String remoteDir = "/";
    private String tmpFileSuffix = ".tmp";
    private String remoteFileSeparator = "/";
    private String temporaryRemoteDir = "/";
    private boolean autoCreateDir = true;
    private FileExistsMode mode = FileExistsMode.REPLACE;
    private boolean useTemporaryFilename = true;
    private Expression filenameExpression;

    @NotBlank
    public String getTemporaryRemoteDir() {
        return this.temporaryRemoteDir;
    }

    public void setTemporaryRemoteDir(String temporaryRemoteDir) {
        this.temporaryRemoteDir = temporaryRemoteDir;
    }

    public boolean isAutoCreateDir() {
        return this.autoCreateDir;
    }

    public void setAutoCreateDir(boolean autoCreateDir) {
        this.autoCreateDir = autoCreateDir;
    }

    @NotNull
    public FileExistsMode getMode() {
        return this.mode;
    }

    public void setMode(FileExistsMode mode) {
        this.mode = mode;
    }

    public boolean isUseTemporaryFilename() {
        return this.useTemporaryFilename;
    }

    public void setUseTemporaryFilename(boolean useTemporaryFilename) {
        this.useTemporaryFilename = useTemporaryFilename;
    }

    public Expression getFilenameExpression() {
        return this.filenameExpression;
    }

    public void setFilenameExpression(Expression filenameExpression) {
        this.filenameExpression = filenameExpression;
    }

    @NotBlank
    public String getRemoteDir() {
        return this.remoteDir;
    }

    public final void setRemoteDir(String remoteDir) {
        this.remoteDir = remoteDir;
    }

    @NotBlank
    public String getTmpFileSuffix() {
        return this.tmpFileSuffix;
    }

    public void setTmpFileSuffix(String tmpFileSuffix) {
        this.tmpFileSuffix = tmpFileSuffix;
    }

    @NotBlank
    public String getRemoteFileSeparator() {
        return this.remoteFileSeparator;
    }

    public void setRemoteFileSeparator(String remoteFileSeparator) {
        this.remoteFileSeparator = remoteFileSeparator;
    }
}

