/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.app.ftp.sink;

import org.apache.commons.net.ftp.FTPFile;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.stream.annotation.EnableBinding;
import org.springframework.cloud.stream.app.ftp.FtpSessionFactoryConfiguration;
import org.springframework.cloud.stream.app.ftp.sink.FtpSinkProperties;
import org.springframework.cloud.stream.messaging.Sink;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.integration.dsl.IntegrationFlow;
import org.springframework.integration.dsl.IntegrationFlowBuilder;
import org.springframework.integration.dsl.IntegrationFlows;
import org.springframework.integration.dsl.MessageHandlerSpec;
import org.springframework.integration.file.remote.RemoteFileTemplate;
import org.springframework.integration.file.remote.session.SessionFactory;
import org.springframework.integration.file.support.FileExistsMode;
import org.springframework.integration.ftp.dsl.Ftp;
import org.springframework.integration.ftp.dsl.FtpMessageHandlerSpec;
import org.springframework.integration.ftp.session.FtpRemoteFileTemplate;

@EnableBinding(value={Sink.class})
@EnableConfigurationProperties(value={FtpSinkProperties.class})
@Import(value={FtpSessionFactoryConfiguration.class})
public class FtpSinkConfiguration {
    @Autowired
    private Sink sink;

    @Bean
    public IntegrationFlow ftpInboundFlow(FtpSinkProperties properties, SessionFactory<FTPFile> ftpSessionFactory) {
        FtpMessageHandlerSpec handlerSpec = (FtpMessageHandlerSpec)((FtpMessageHandlerSpec)((FtpMessageHandlerSpec)((FtpMessageHandlerSpec)Ftp.outboundAdapter((RemoteFileTemplate)new FtpRemoteFileTemplate(ftpSessionFactory), (FileExistsMode)properties.getMode()).remoteDirectory(properties.getRemoteDir())).remoteFileSeparator(properties.getRemoteFileSeparator())).autoCreateDirectory(properties.isAutoCreateDir())).temporaryFileSuffix(properties.getTmpFileSuffix());
        if (properties.getFilenameExpression() != null) {
            handlerSpec.fileNameExpression(properties.getFilenameExpression().getExpressionString());
        }
        return ((IntegrationFlowBuilder)IntegrationFlows.from((String)"input").handle((MessageHandlerSpec)handlerSpec)).get();
    }
}

