/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.app.counter.sink;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.metrics.CounterService;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.stream.annotation.EnableBinding;
import org.springframework.cloud.stream.app.counter.sink.CounterProperties;
import org.springframework.cloud.stream.app.counter.sink.CounterSinkStoreConfiguration;
import org.springframework.cloud.stream.messaging.Sink;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.expression.EvaluationContext;
import org.springframework.integration.annotation.ServiceActivator;
import org.springframework.messaging.Message;

@EnableBinding(value={Sink.class})
@EnableConfigurationProperties(value={CounterProperties.class})
@Configuration
@Import(value={CounterSinkStoreConfiguration.class})
public class CounterSinkConfiguration {
    private static final Log logger = LogFactory.getLog(CounterSinkConfiguration.class);
    @Autowired
    private CounterService counterService;
    @Autowired
    private CounterProperties counterSinkProperties;
    @Autowired
    private EvaluationContext evaluationContext;

    @ServiceActivator(inputChannel="input")
    public void count(Message<?> message) {
        String name = this.computeMetricName(message);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("Received: %s, about to increment counter named '%s'", message, name));
        }
        if (!name.startsWith("counter.")) {
            name = "counter." + name;
        }
        this.counterService.increment(name);
    }

    protected String computeMetricName(Message<?> message) {
        if (this.counterSinkProperties.getName() != null) {
            return this.counterSinkProperties.getName();
        }
        return ((CharSequence)this.counterSinkProperties.getNameExpression().getValue(this.evaluationContext, message, CharSequence.class)).toString();
    }
}

