/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.app.cassandra.query;

import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.cloud.stream.app.cassandra.query.ColumnNameExtractor;
import org.springframework.util.StringUtils;

public class InsertQueryColumnNameExtractor
implements ColumnNameExtractor {
    private static final Pattern PATTERN = Pattern.compile(".+\\((.+)\\).+(?:values\\s*\\((.+)\\))");

    @Override
    public List<String> extract(String query) {
        LinkedList<String> extractedColumns = new LinkedList<String>();
        Matcher matcher = PATTERN.matcher(query);
        if (matcher.matches()) {
            String[] columns = StringUtils.delimitedListToStringArray((String)matcher.group(1), (String)",", (String)" ");
            String[] params = StringUtils.delimitedListToStringArray((String)matcher.group(2), (String)",", (String)" ");
            for (int i = 0; i < columns.length; ++i) {
                String param = params[i];
                if (param.equals("?")) {
                    extractedColumns.add(columns[i]);
                    continue;
                }
                if (!param.startsWith(":")) continue;
                extractedColumns.add(param.substring(1));
            }
        } else {
            throw new IllegalArgumentException("Invalid CQL insert query syntax: " + query);
        }
        return extractedColumns;
    }
}

