/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.app.cassandra;

import com.datastax.driver.core.AuthProvider;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.JdkSSLOptions;
import com.datastax.driver.core.PlainTextAuthProvider;
import com.datastax.driver.core.SSLOptions;
import com.datastax.driver.core.Session;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.List;
import java.util.Scanner;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cassandra.config.ClusterBuilderConfigurer;
import org.springframework.cassandra.config.CompressionType;
import org.springframework.cassandra.core.CqlTemplate;
import org.springframework.cassandra.core.keyspace.CreateKeyspaceSpecification;
import org.springframework.cloud.stream.app.cassandra.CassandraProperties;
import org.springframework.cloud.stream.app.cassandra.util.TrustAllSSLContextFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.cassandra.config.SchemaAction;
import org.springframework.data.cassandra.config.java.AbstractCassandraConfiguration;
import org.springframework.util.StringUtils;

@Configuration
@EnableConfigurationProperties(value={CassandraProperties.class})
public class CassandraConfiguration
extends AbstractCassandraConfiguration {
    @Autowired
    CassandraProperties cassandraProperties;

    protected String getContactPoints() {
        return this.cassandraProperties.getContactPoints();
    }

    protected int getPort() {
        return this.cassandraProperties.getPort();
    }

    protected String getKeyspaceName() {
        return this.cassandraProperties.getKeyspace();
    }

    protected AuthProvider getAuthProvider() {
        if (StringUtils.hasText((String)this.cassandraProperties.getUsername())) {
            return new PlainTextAuthProvider(this.cassandraProperties.getUsername(), this.cassandraProperties.getPassword());
        }
        return null;
    }

    public SchemaAction getSchemaAction() {
        return this.cassandraProperties.getSchemaAction();
    }

    public String[] getEntityBasePackages() {
        return this.cassandraProperties.getEntityBasePackages();
    }

    protected CompressionType getCompressionType() {
        return this.cassandraProperties.getCompressionType();
    }

    protected boolean getMetricsEnabled() {
        return this.cassandraProperties.isMetricsEnabled();
    }

    protected List<CreateKeyspaceSpecification> getKeyspaceCreations() {
        if (this.cassandraProperties.isCreateKeyspace()) {
            return Collections.singletonList(CreateKeyspaceSpecification.createKeyspace((String)this.getKeyspaceName()).withSimpleReplication().ifNotExists());
        }
        return super.getKeyspaceCreations();
    }

    protected ClusterBuilderConfigurer getClusterBuilderConfigurer() {
        return new ClusterBuilderConfigurer(){

            public Cluster.Builder configure(Cluster.Builder clusterBuilder) {
                if (CassandraConfiguration.this.cassandraProperties.isUseSsl()) {
                    JdkSSLOptions.Builder optsBuilder = JdkSSLOptions.builder();
                    if (CassandraConfiguration.this.cassandraProperties.isSkipSslValidation()) {
                        try {
                            optsBuilder.withSSLContext(TrustAllSSLContextFactory.getSslContext());
                        }
                        catch (KeyManagementException | NoSuchAlgorithmException e) {
                            throw new RuntimeException("Unable to configure a Cassandra cluster using SSL.", e);
                        }
                    }
                    return clusterBuilder.withSSL((SSLOptions)optsBuilder.build());
                }
                return clusterBuilder;
            }
        };
    }

    @Configuration
    protected static class CassandraKeyspaceInitializerConfiguration {
        @Autowired
        CassandraProperties cassandraProperties;
        @Autowired
        Session session;

        protected CassandraKeyspaceInitializerConfiguration() {
        }

        @PostConstruct
        public void init() throws IOException {
            if (this.cassandraProperties.getInitScript() != null) {
                String scripts = new Scanner(this.cassandraProperties.getInitScript().getInputStream(), "UTF-8").useDelimiter("\\A").next();
                CqlTemplate template = new CqlTemplate(this.session);
                for (String script : StringUtils.delimitedListToStringArray((String)scripts, (String)";", (String)"\r\n\f")) {
                    if (!StringUtils.hasText((String)script)) continue;
                    template.execute(script + ";");
                }
            }
        }
    }
}

