/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.app.cassandra;

import javax.validation.constraints.AssertFalse;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.Range;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cassandra.config.CompressionType;
import org.springframework.core.io.Resource;
import org.springframework.data.cassandra.config.SchemaAction;
import org.springframework.util.StringUtils;
import org.springframework.validation.annotation.Validated;

@ConfigurationProperties(value="cassandra.cluster")
@Validated
public class CassandraProperties {
    private String contactPoints = "localhost";
    private int port = 9042;
    @Value(value="${spring.application.name:tmp}")
    private String keyspace;
    private boolean createKeyspace;
    private SchemaAction schemaAction = SchemaAction.NONE;
    private String username;
    private String password;
    private Resource initScript;
    private String[] entityBasePackages = new String[0];
    private CompressionType compressionType = CompressionType.NONE;
    private boolean useSsl;
    private boolean skipSslValidation;
    private boolean metricsEnabled = true;

    public void setContactPoints(String contactPoints) {
        this.contactPoints = contactPoints;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setKeyspace(String keyspace) {
        this.keyspace = keyspace;
    }

    public void setCreateKeyspace(boolean createKeyspace) {
        this.createKeyspace = createKeyspace;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setInitScript(Resource initScript) {
        this.initScript = initScript;
    }

    public void setEntityBasePackages(String[] entityBasePackages) {
        this.entityBasePackages = entityBasePackages;
    }

    public void setCompressionType(CompressionType compressionType) {
        this.compressionType = compressionType;
    }

    public void setMetricsEnabled(boolean metricsEnabled) {
        this.metricsEnabled = metricsEnabled;
    }

    public void setUseSsl(boolean useSsl) {
        this.useSsl = useSsl;
    }

    public void setSkipSslValidation(boolean skipSslValidation) {
        this.skipSslValidation = skipSslValidation;
    }

    @NotNull
    public String getContactPoints() {
        return this.contactPoints;
    }

    @Range(min=0L, max=65535L)
    public int getPort() {
        return this.port;
    }

    public String getKeyspace() {
        return this.keyspace;
    }

    public boolean isCreateKeyspace() {
        return this.createKeyspace;
    }

    @NotNull
    public SchemaAction getSchemaAction() {
        return this.schemaAction;
    }

    public void setSchemaAction(SchemaAction schemaAction) {
        this.schemaAction = schemaAction;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public Resource getInitScript() {
        return this.initScript;
    }

    public String[] getEntityBasePackages() {
        return this.entityBasePackages;
    }

    @NotNull
    public CompressionType getCompressionType() {
        return this.compressionType;
    }

    public boolean isMetricsEnabled() {
        return this.metricsEnabled;
    }

    public boolean isUseSsl() {
        return this.useSsl;
    }

    public boolean isSkipSslValidation() {
        return this.skipSslValidation;
    }

    @AssertFalse(message="both 'username' and 'password' are required or neither one")
    private boolean isInvalid() {
        return StringUtils.hasText((String)this.username) ^ StringUtils.hasText((String)this.password);
    }
}

