/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.app.cassandra.query;

import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.cloud.stream.app.cassandra.query.ColumnNameExtractor;
import org.springframework.util.StringUtils;

public class UpdateQueryColumnNameExtractor
implements ColumnNameExtractor {
    private static final Pattern PATTERN = Pattern.compile("(?i)(?<=set)(.*)(?=where)where(.*)");

    @Override
    public List<String> extract(String query) {
        LinkedList<String> extractedColumns = new LinkedList<String>();
        Matcher matcher = PATTERN.matcher(query);
        if (!matcher.find()) {
            throw new IllegalArgumentException("Invalid CQL update query syntax: " + query);
        }
        String[] settings = StringUtils.delimitedListToStringArray((String)matcher.group(1), (String)",", (String)" ");
        String[] where = StringUtils.delimitedListToStringArray((String)matcher.group(2), (String)",", (String)" ");
        this.readPairs(extractedColumns, settings);
        this.readPairs(extractedColumns, where);
        return extractedColumns;
    }

    protected void readPairs(List<String> extractedColumns, String[] settings) {
        for (String setting : settings) {
            String[] columnValuePair = StringUtils.delimitedListToStringArray((String)setting, (String)"=", (String)" ");
            if (!columnValuePair[1].startsWith(":") && !columnValuePair[1].equals("?")) continue;
            extractedColumns.add(columnValuePair[0]);
        }
    }
}

