/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.app.gemfire.config;

import java.util.Properties;
import org.apache.geode.LogWriter;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.security.AuthInitialize;
import org.apache.geode.security.AuthenticationFailedException;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(value="gemfire.security")
public class GemfireSecurityProperties {
    private String username;
    private String password;

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public static class UserAuthInitialize
    implements AuthInitialize {
        private static final String USERNAME = "security-username";
        private static final String PASSWORD = "security-password";
        private LogWriter securitylog;
        private LogWriter systemlog;

        public static AuthInitialize create() {
            return new UserAuthInitialize();
        }

        public void init(LogWriter systemLogger, LogWriter securityLogger) throws AuthenticationFailedException {
            this.systemlog = systemLogger;
            this.securitylog = securityLogger;
        }

        public Properties getCredentials(Properties props, DistributedMember server, boolean isPeer) throws AuthenticationFailedException {
            String username = props.getProperty(USERNAME);
            if (username == null) {
                throw new AuthenticationFailedException("UserAuthInitialize: username not set.");
            }
            String password = props.getProperty(PASSWORD);
            if (password == null) {
                throw new AuthenticationFailedException("UserAuthInitialize: password not set.");
            }
            Properties properties = new Properties();
            properties.setProperty(USERNAME, username);
            properties.setProperty(PASSWORD, password);
            return properties;
        }

        public void close() {
        }
    }
}

