/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.app.gemfire;

import com.gemstone.gemfire.pdx.JSONFormatter;
import com.gemstone.gemfire.pdx.PdxInstance;
import com.gemstone.org.json.JSONException;
import com.gemstone.org.json.JSONObject;
import org.springframework.integration.transformer.MessageTransformationException;

public class JsonObjectTransformer {
    public PdxInstance toObject(String json) {
        JSONObject jsonObject = null;
        try {
            jsonObject = new JSONObject(json);
        }
        catch (JSONException e) {
            throw new MessageTransformationException(e.getMessage());
        }
        return JSONFormatter.fromJSON((String)jsonObject.toString());
    }

    public String toString(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof PdxInstance) {
            String json = JSONFormatter.toJSON((PdxInstance)((PdxInstance)obj));
            return json.replaceAll("\\r\\n\\s*", "").replaceAll("\\n\\s*", "").replaceAll("\\s*:\\s*", ":").trim();
        }
        return obj.toString();
    }
}

