/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.app.sftp;

import com.jcraft.jsch.ChannelSftp;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.stream.app.sftp.SftpSessionFactoryProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.integration.file.remote.session.CachingSessionFactory;
import org.springframework.integration.file.remote.session.SessionFactory;
import org.springframework.integration.sftp.session.DefaultSftpSessionFactory;

@Configuration
@EnableConfigurationProperties(value={SftpSessionFactoryProperties.class})
public class SftpSessionFactoryConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public SessionFactory<ChannelSftp.LsEntry> sftpSessionFactory(SftpSessionFactoryProperties properties) {
        DefaultSftpSessionFactory sftpSessionFactory = new DefaultSftpSessionFactory();
        sftpSessionFactory.setHost(properties.getHost());
        sftpSessionFactory.setPort(properties.getPort());
        sftpSessionFactory.setUser(properties.getUsername());
        sftpSessionFactory.setPassword(properties.getPassword());
        sftpSessionFactory.setAllowUnknownKeys(properties.isAllowUnknownKeys());
        if (properties.getKnownHostsExpression() != null) {
            sftpSessionFactory.setKnownHosts("#{" + properties.getKnownHostsExpression() + "}");
        }
        if (properties.getCacheSessions() != null) {
            CachingSessionFactory csf = new CachingSessionFactory((SessionFactory)sftpSessionFactory);
            return csf;
        }
        return sftpSessionFactory;
    }
}

