/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.app.trigger;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.AssertFalse;
import javax.validation.constraints.Min;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.stream.app.time.DateFormat;
import org.springframework.cloud.stream.app.trigger.TriggerProperties;
import org.springframework.util.StringUtils;
import org.springframework.validation.annotation.Validated;

@ConfigurationProperties(value="trigger")
@Validated
public class TriggerPropertiesMaxMessagesDefaultUnlimited
implements TriggerProperties {
    private long maxMessages = -1L;
    private int fixedDelay = 1;
    private int initialDelay = 0;
    private TimeUnit timeUnit = TimeUnit.SECONDS;
    private String date;
    private String dateFormat = "MM/dd/yy HH:mm:ss";
    private String cron;

    public long getMaxMessages() {
        return this.maxMessages;
    }

    public void setMaxMessages(long maxMessages) {
        this.maxMessages = maxMessages;
    }

    @Min(value=0L)
    public int getInitialDelay() {
        return this.initialDelay;
    }

    public void setInitialDelay(int initialDelay) {
        this.initialDelay = initialDelay;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public void setTimeUnit(TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
    }

    public int getFixedDelay() {
        return this.fixedDelay;
    }

    public void setFixedDelay(int fixedDelay) {
        this.fixedDelay = fixedDelay;
    }

    public String getCron() {
        return this.cron;
    }

    public void setCron(String cron) {
        this.cron = cron;
    }

    public Date getDate() {
        if (StringUtils.hasText((String)this.date)) {
            try {
                return new SimpleDateFormat(this.dateFormat).parse(this.date);
            }
            catch (ParseException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return null;
    }

    public void setDate(String date) {
        this.date = date;
    }

    @DateFormat
    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    @AssertFalse
    public boolean isMutuallyExclusive() {
        return this.date != null && this.cron != null && this.fixedDelay != 1;
    }
}

