/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.app.s3;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.aws.context.annotation.ConditionalOnMissingAmazonClient;
import org.springframework.cloud.aws.core.region.RegionProvider;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnMissingAmazonClient(value=AmazonS3.class)
public class AmazonS3Configuration {
    @Bean
    @ConditionalOnMissingBean
    public AmazonS3 amazonS3(AWSCredentialsProvider awsCredentialsProvider, RegionProvider regionProvider) {
        return (AmazonS3)new AmazonS3Client(awsCredentialsProvider).withRegion(regionProvider.getRegion());
    }
}

