/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.app.ftp;

import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.Range;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.stream.app.file.remote.AbstractRemoteServerProperties;

@ConfigurationProperties(value="ftp.factory")
public class FtpSessionFactoryProperties
extends AbstractRemoteServerProperties {
    private int port = 21;
    private ClientMode clientMode = ClientMode.PASSIVE;

    @Range(min=0L, max=65535L)
    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    @NotNull
    public ClientMode getClientMode() {
        return this.clientMode;
    }

    public void setClientMode(ClientMode clientMode) {
        this.clientMode = clientMode;
    }

    public static enum ClientMode {
        ACTIVE(0),
        PASSIVE(2);

        private final int mode;

        private ClientMode(int mode) {
            this.mode = mode;
        }

        public int getMode() {
            return this.mode;
        }
    }
}

