/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.app.file.remote;

import org.springframework.integration.file.remote.RemoteFileTemplate;
import org.springframework.integration.transaction.IntegrationResourceHolder;
import org.springframework.integration.transaction.TransactionSynchronizationProcessor;

public class RemoteFileDeletingTransactionSynchronizationProcessor
implements TransactionSynchronizationProcessor {
    private final RemoteFileTemplate<?> template;
    private final String remoteFileSeparator;

    public RemoteFileDeletingTransactionSynchronizationProcessor(RemoteFileTemplate<?> template, String remoteFileSeparator) {
        this.template = template;
        this.remoteFileSeparator = remoteFileSeparator;
    }

    public void processBeforeCommit(IntegrationResourceHolder holder) {
    }

    public void processAfterRollback(IntegrationResourceHolder holder) {
    }

    public void processAfterCommit(IntegrationResourceHolder holder) {
        String remoteDir = (String)holder.getMessage().getHeaders().get((Object)"file_remoteDirectory");
        String remoteFile = (String)holder.getMessage().getHeaders().get((Object)"file_remoteFile");
        this.template.remove(remoteDir + this.remoteFileSeparator + remoteFile);
    }
}

