/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.app.file;

import javax.validation.constraints.AssertTrue;
import javax.validation.constraints.NotNull;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.stream.app.file.FileReadingMode;
import org.springframework.validation.annotation.Validated;

@ConfigurationProperties(value="file.consumer")
@Validated
public class FileConsumerProperties {
    private FileReadingMode mode = FileReadingMode.contents;
    private Boolean withMarkers = null;
    private boolean markersJson = true;

    @NotNull
    public FileReadingMode getMode() {
        return this.mode;
    }

    public void setMode(FileReadingMode mode) {
        this.mode = mode;
    }

    public Boolean getWithMarkers() {
        return this.withMarkers;
    }

    public void setWithMarkers(Boolean withMarkers) {
        this.withMarkers = withMarkers;
    }

    public boolean getMarkersJson() {
        return this.markersJson;
    }

    public void setMarkersJson(boolean markersJson) {
        this.markersJson = markersJson;
    }

    @AssertTrue(message="withMarkers can only be supplied when FileReadingMode is 'lines'")
    public @AssertTrue(message="withMarkers can only be supplied when FileReadingMode is 'lines'") boolean isWithMarkersValid() {
        return this.withMarkers == null || FileReadingMode.lines == this.mode;
    }
}

