/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.app.file.remote;

import java.nio.file.Paths;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;

public abstract class FilePathUtils {
    @Nullable
    public static String getRemoteFilePath(Message message) {
        if (message.getHeaders().containsKey((Object)"file_remoteDirectory")) {
            String filename = (String)message.getPayload();
            String remoteDirectory = (String)message.getHeaders().get((Object)"file_remoteDirectory");
            return FilePathUtils.getPath(remoteDirectory, filename);
        }
        return null;
    }

    public static String getLocalFilePath(String localDirectory, String filename) {
        if (localDirectory != null) {
            return FilePathUtils.getPath(localDirectory, filename);
        }
        return filename;
    }

    private static String getPath(String dirName, String fileName) {
        return Paths.get(dirName, fileName).toString();
    }
}

