/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.zookeeper.sample;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.restclient.RestTemplateBuilder;
import org.springframework.boot.restclient.RestTemplateCustomizer;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.client.loadbalancer.LoadBalanced;
import org.springframework.cloud.client.loadbalancer.LoadBalancerClient;
import org.springframework.cloud.client.serviceregistry.Registration;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.cloud.zookeeper.sample.SampleZookeeperApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;

@Configuration(proxyBeanMethods=false)
@EnableAutoConfiguration
@RestController
@EnableFeignClients
public class SampleZookeeperApplication {
    @Value(value="${spring.application.name:testZookeeperApp}")
    private String appName;
    @Autowired
    private LoadBalancerClient loadBalancer;
    @Autowired
    private DiscoveryClient discovery;
    @Autowired
    private Environment env;
    @Autowired
    private AppClient appClient;
    @Autowired(required=false)
    private Registration registration;
    private RestTemplate rest;

    @RequestMapping(value={"/"})
    public ServiceInstance lb() {
        return this.loadBalancer.choose(this.appName);
    }

    @RequestMapping(value={"/hi"})
    public String hi() {
        return "Hello World! from " + this.registration;
    }

    @RequestMapping(value={"/self"})
    public String self() {
        return this.appClient.hi();
    }

    @RequestMapping(value={"/myenv"})
    public String env(@RequestParam(value="prop") String prop) {
        return this.env.getProperty(prop, "Not Found");
    }

    public String rt() {
        return (String)this.rest.getForObject("http://" + this.appName + "/hi", String.class, new Object[0]);
    }

    @Bean
    @LoadBalanced
    RestTemplate loadBalancedRestTemplate() {
        this.rest = new RestTemplateBuilder(new RestTemplateCustomizer[0]).build();
        return this.rest;
    }

    public static void main(String[] args) {
        SpringApplication.run(SampleZookeeperApplication.class, (String[])args);
    }
}

