/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.zookeeper.discovery;

import jakarta.annotation.PreDestroy;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.cache.TreeCache;
import org.apache.curator.framework.recipes.cache.TreeCacheEvent;
import org.apache.curator.framework.recipes.cache.TreeCacheListener;
import org.springframework.cloud.client.discovery.event.HeartbeatEvent;
import org.springframework.cloud.client.discovery.event.InstanceRegisteredEvent;
import org.springframework.cloud.zookeeper.discovery.ZookeeperDiscoveryProperties;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.ApplicationListener;
import org.springframework.util.ReflectionUtils;

public class ZookeeperServiceWatch
implements ApplicationListener<InstanceRegisteredEvent<?>>,
TreeCacheListener,
ApplicationEventPublisherAware {
    private final CuratorFramework curator;
    private final ZookeeperDiscoveryProperties properties;
    private final AtomicLong cacheChange = new AtomicLong(0L);
    private ApplicationEventPublisher publisher;
    private TreeCache cache;

    public ZookeeperServiceWatch(CuratorFramework curator, ZookeeperDiscoveryProperties properties) {
        this.curator = curator;
        this.properties = properties;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher publisher) {
        this.publisher = publisher;
    }

    public TreeCache getCache() {
        return this.cache;
    }

    public void onApplicationEvent(InstanceRegisteredEvent<?> event) {
        this.cache = TreeCache.newBuilder((CuratorFramework)this.curator, (String)this.properties.getRoot()).build();
        this.cache.getListenable().addListener((Object)this);
        try {
            this.cache.start();
        }
        catch (Exception e) {
            ReflectionUtils.rethrowRuntimeException((Throwable)e);
        }
    }

    @PreDestroy
    public void stop() throws Exception {
        if (this.cache != null) {
            this.cache.close();
        }
    }

    public void childEvent(CuratorFramework client, TreeCacheEvent event) throws Exception {
        if (event.getType().equals((Object)TreeCacheEvent.Type.NODE_ADDED) || event.getType().equals((Object)TreeCacheEvent.Type.NODE_REMOVED) || event.getType().equals((Object)TreeCacheEvent.Type.NODE_UPDATED)) {
            long newCacheChange = this.cacheChange.incrementAndGet();
            this.publisher.publishEvent((ApplicationEvent)new HeartbeatEvent((Object)this, (Object)newCacheChange));
        }
    }
}

