/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.zookeeper.discovery.dependency;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.zookeeper.discovery.DependencyPathUtils;
import org.springframework.cloud.zookeeper.discovery.dependency.StubsConfiguration;
import org.springframework.cloud.zookeeper.discovery.dependency.ZookeeperDependency;
import org.springframework.util.StringUtils;

@ConfigurationProperties(value="spring.cloud.zookeeper")
public class ZookeeperDependencies {
    private String prefix = "";
    private Map<String, ZookeeperDependency> dependencies = new LinkedHashMap<String, ZookeeperDependency>();

    @PostConstruct
    public void init() {
        if (StringUtils.hasText((String)this.prefix)) {
            this.prefix = DependencyPathUtils.sanitize(this.prefix);
        }
        for (Map.Entry<String, ZookeeperDependency> entry : this.dependencies.entrySet()) {
            ZookeeperDependency value = entry.getValue();
            if (!StringUtils.hasText((String)value.getPath())) {
                value.setPath(entry.getKey());
            }
            value.setPath(DependencyPathUtils.sanitize(value.getPath()));
            if (StringUtils.hasText((String)this.prefix)) {
                value.setPath(this.prefix + value.getPath());
            }
            this.setStubDefinition(value);
        }
    }

    private void setStubDefinition(ZookeeperDependency value) {
        if (!StringUtils.hasText((String)value.getStubs())) {
            value.setStubsConfiguration(new StubsConfiguration(new StubsConfiguration.DependencyPath(value.getPath())));
        } else {
            value.setStubsConfiguration(new StubsConfiguration(value.getStubs()));
        }
    }

    public Collection<ZookeeperDependency> getDependencyConfigurations() {
        return this.dependencies.values();
    }

    public boolean hasDependencies() {
        return !this.dependencies.isEmpty();
    }

    public ZookeeperDependency getDependencyForPath(String path) {
        for (Map.Entry<String, ZookeeperDependency> zookeeperDependencyEntry : this.dependencies.entrySet()) {
            if (!zookeeperDependencyEntry.getValue().getPath().equals(path)) continue;
            return zookeeperDependencyEntry.getValue();
        }
        return null;
    }

    public ZookeeperDependency getDependencyForAlias(String alias) {
        for (Map.Entry<String, ZookeeperDependency> zookeeperDependencyEntry : this.dependencies.entrySet()) {
            if (!zookeeperDependencyEntry.getKey().equals(alias)) continue;
            return zookeeperDependencyEntry.getValue();
        }
        return null;
    }

    public String getPathForAlias(String alias) {
        ZookeeperDependency dependency = this.getDependencyForAlias(alias);
        if (dependency != null) {
            return dependency.getPath();
        }
        return "";
    }

    public String getAliasForPath(String path) {
        for (Map.Entry<String, ZookeeperDependency> zookeeperDependencyEntry : this.dependencies.entrySet()) {
            if (!zookeeperDependencyEntry.getValue().getPath().equals(path)) continue;
            return zookeeperDependencyEntry.getKey();
        }
        return "";
    }

    public Collection<String> getDependencyNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (Map.Entry<String, ZookeeperDependency> zookeeperDependencyEntry : this.dependencies.entrySet()) {
            names.add(zookeeperDependencyEntry.getValue().getPath());
        }
        return names;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public Map<String, ZookeeperDependency> getDependencies() {
        return this.dependencies;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setDependencies(Map<String, ZookeeperDependency> dependencies) {
        this.dependencies = dependencies;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ZookeeperDependencies{");
        sb.append("prefix='").append(this.prefix).append('\'');
        sb.append(", dependencies=").append(this.dependencies);
        sb.append('}');
        return sb.toString();
    }
}

