/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.zookeeper.support;

import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.x.discovery.ServiceDiscovery;
import org.apache.curator.x.discovery.ServiceDiscoveryBuilder;
import org.apache.curator.x.discovery.details.InstanceSerializer;
import org.apache.curator.x.discovery.details.JsonInstanceSerializer;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.zookeeper.discovery.ConditionalOnZookeeperDiscoveryEnabled;
import org.springframework.cloud.zookeeper.discovery.ZookeeperDiscoveryAutoConfiguration;
import org.springframework.cloud.zookeeper.discovery.ZookeeperDiscoveryProperties;
import org.springframework.cloud.zookeeper.discovery.ZookeeperInstance;
import org.springframework.cloud.zookeeper.discovery.ZookeeperServiceDiscovery;
import org.springframework.cloud.zookeeper.serviceregistry.ZookeeperServiceRegistryAutoConfiguration;
import org.springframework.cloud.zookeeper.support.DefaultServiceDiscoveryCustomizer;
import org.springframework.cloud.zookeeper.support.ServiceDiscoveryCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnZookeeperDiscoveryEnabled
@AutoConfigureBefore(value={ZookeeperDiscoveryAutoConfiguration.class, ZookeeperServiceRegistryAutoConfiguration.class})
public class CuratorServiceDiscoveryAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={ServiceDiscoveryCustomizer.class})
    public DefaultServiceDiscoveryCustomizer defaultServiceDiscoveryCustomizer(CuratorFramework curator, ZookeeperDiscoveryProperties properties, InstanceSerializer<ZookeeperInstance> serializer) {
        return new DefaultServiceDiscoveryCustomizer(curator, properties, serializer);
    }

    @Bean
    @ConditionalOnMissingBean
    public InstanceSerializer<ZookeeperInstance> deprecatedInstanceSerializer() {
        return new JsonInstanceSerializer(ZookeeperInstance.class);
    }

    @Configuration
    @ConditionalOnMissingBean(value={ZookeeperServiceDiscovery.class})
    protected static class CuratorServiceDiscoveryConfiguration {
        protected CuratorServiceDiscoveryConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public ServiceDiscovery<ZookeeperInstance> curatorServiceDiscovery(ServiceDiscoveryCustomizer customizer) {
            return customizer.customize((ServiceDiscoveryBuilder<ZookeeperInstance>)ServiceDiscoveryBuilder.builder(ZookeeperInstance.class));
        }
    }
}

