/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.zookeeper.config;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;

@ConfigurationProperties(value="spring.cloud.zookeeper.config")
public class ZookeeperConfigProperties {
    public static final String PREFIX = "spring.cloud.zookeeper.config";
    private boolean enabled = true;
    private String root = "config";
    private String name;
    private String defaultContext = "application";
    private String profileSeparator = ",";
    private boolean failFast = true;

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getRoot() {
        return this.root;
    }

    public void setRoot(String root) {
        this.root = root;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDefaultContext() {
        return this.defaultContext;
    }

    public void setDefaultContext(String defaultContext) {
        Assert.hasText((String)defaultContext, (String)"spring.cloud.zookeeper.config.default-context may not be empty");
        this.defaultContext = defaultContext;
    }

    public String getProfileSeparator() {
        return this.profileSeparator;
    }

    public void setProfileSeparator(String profileSeparator) {
        Assert.hasText((String)profileSeparator, (String)"spring.cloud.zookeeper.config.profile-separator may not be empty");
        this.profileSeparator = profileSeparator;
    }

    public boolean isFailFast() {
        return this.failFast;
    }

    public void setFailFast(boolean failFast) {
        this.failFast = failFast;
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("enabled", this.enabled).append("root", (Object)this.root).append("name", (Object)this.name).append("defaultContext", (Object)this.defaultContext).append("profileSeparator", (Object)this.profileSeparator).append("failFast", this.failFast).toString();
    }
}

