/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.zookeeper.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.springframework.boot.BootstrapRegistry;
import org.springframework.boot.context.config.ConfigDataLocationNotFoundException;
import org.springframework.boot.context.config.ConfigDataLocationResolver;
import org.springframework.boot.context.config.ConfigDataLocationResolverContext;
import org.springframework.boot.context.config.Profiles;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.cloud.zookeeper.CuratorFactory;
import org.springframework.cloud.zookeeper.config.ZookeeperConfigDataLocation;
import org.springframework.cloud.zookeeper.config.ZookeeperConfigProperties;
import org.springframework.cloud.zookeeper.config.ZookeeperPropertySources;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public class ZookeeperConfigDataLocationResolver
implements ConfigDataLocationResolver<ZookeeperConfigDataLocation> {
    public static final String PREFIX = "zookeeper:";
    private final Log log;

    public ZookeeperConfigDataLocationResolver(Log log) {
        this.log = log;
    }

    public boolean isResolvable(ConfigDataLocationResolverContext context, String location) {
        if (!location.startsWith(PREFIX)) {
            return false;
        }
        boolean zkEnabled = (Boolean)context.getBinder().bind("spring.cloud.zookeeper.enabled", Boolean.class).orElse((Object)true);
        boolean zkConfigEnabled = (Boolean)context.getBinder().bind("spring.cloud.zookeeper.config.enabled", Boolean.class).orElse((Object)true);
        return zkConfigEnabled && zkEnabled;
    }

    public List<ZookeeperConfigDataLocation> resolve(ConfigDataLocationResolverContext context, String location, boolean optional) throws ConfigDataLocationNotFoundException {
        return Collections.emptyList();
    }

    public List<ZookeeperConfigDataLocation> resolveProfileSpecific(ConfigDataLocationResolverContext context, String location, boolean optional, Profiles profiles) throws ConfigDataLocationNotFoundException {
        UriComponents locationUri = this.parseLocation(location);
        CuratorFactory.registerCurator((BootstrapRegistry)context.getBootstrapContext(), (UriComponents)locationUri, (boolean)optional);
        ZookeeperConfigProperties properties = this.loadConfigProperties(context.getBinder());
        context.getBootstrapContext().register(ZookeeperConfigProperties.class, BootstrapRegistry.InstanceSupplier.of((Object)properties));
        ZookeeperPropertySources sources = new ZookeeperPropertySources(properties, this.log);
        List<String> contexts = locationUri == null || CollectionUtils.isEmpty((Collection)locationUri.getPathSegments()) ? sources.getAutomaticContexts(profiles.getAccepted()) : this.getCustomContexts(locationUri);
        context.getBootstrapContext().addCloseListener(event -> {
            HashMap<String, List> source = new HashMap<String, List>();
            source.put("spring.cloud.zookeeper.config.property-source-contexts", contexts);
            MapPropertySource propertySource = new MapPropertySource("zookeeperConfigData", source);
            event.getApplicationContext().getEnvironment().getPropertySources().addFirst((PropertySource)propertySource);
        });
        ArrayList<ZookeeperConfigDataLocation> locations = new ArrayList<ZookeeperConfigDataLocation>();
        contexts.forEach(propertySourceContext -> locations.add(new ZookeeperConfigDataLocation((String)propertySourceContext, optional)));
        return locations;
    }

    protected List<String> getCustomContexts(UriComponents uriComponents) {
        if (StringUtils.isEmpty((Object)uriComponents.getPath())) {
            return Collections.emptyList();
        }
        return Arrays.asList(uriComponents.getPath().split(";"));
    }

    @Nullable
    protected UriComponents parseLocation(String location) {
        String uri = location.substring(PREFIX.length());
        if (!StringUtils.hasText((String)uri)) {
            return null;
        }
        uri = !uri.startsWith("//") ? "zookeeper://" + uri : location;
        return UriComponentsBuilder.fromUriString((String)uri).build();
    }

    protected ZookeeperConfigProperties loadConfigProperties(Binder binder) {
        ZookeeperConfigProperties properties = (ZookeeperConfigProperties)binder.bind("spring.cloud.zookeeper.config", Bindable.of(ZookeeperConfigProperties.class)).orElse((Object)new ZookeeperConfigProperties());
        if (StringUtils.isEmpty((Object)properties.getName())) {
            properties.setName((String)binder.bind("spring.application.name", String.class).orElse((Object)"application"));
        }
        return properties;
    }
}

