/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.zookeeper.config;

import org.apache.curator.framework.CuratorFramework;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.zookeeper.ConditionalOnZookeeperEnabled;
import org.springframework.cloud.zookeeper.ZookeeperAutoConfiguration;
import org.springframework.cloud.zookeeper.config.ZookeeperConfigProperties;
import org.springframework.cloud.zookeeper.config.ZookeeperPropertySourceLocator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;

@Configuration(proxyBeanMethods=false)
@ConditionalOnZookeeperEnabled
@Import(value={ZookeeperAutoConfiguration.class})
public class ZookeeperConfigBootstrapConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public ZookeeperPropertySourceLocator zookeeperPropertySourceLocator(CuratorFramework curator, ZookeeperConfigProperties properties) {
        return new ZookeeperPropertySourceLocator(curator, properties);
    }

    @Bean
    @ConditionalOnMissingBean
    public ZookeeperConfigProperties zookeeperConfigProperties(Environment env) {
        ZookeeperConfigProperties properties = new ZookeeperConfigProperties();
        if (StringUtils.isEmpty((Object)properties.getName())) {
            properties.setName(env.getProperty("spring.application.name", "application"));
        }
        return properties;
    }
}

