/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.vault.config;

import java.net.URI;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.DeprecatedConfigurationProperty;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.core.io.Resource;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;
import org.springframework.vault.authentication.AzureMsiAuthenticationOptions;
import org.springframework.vault.core.lease.LeaseEndpoints;

@ConfigurationProperties(value="spring.cloud.vault")
public class VaultProperties
implements EnvironmentAware {
    public static final String PREFIX = "spring.cloud.vault";
    private boolean enabled = true;
    private String host = "localhost";
    private int port = 8200;
    private String scheme = "https";
    @Nullable
    private String uri;
    @Nullable
    private String namespace;
    private Reactive reactive = new Reactive();
    private Discovery discovery = new Discovery();
    private int connectionTimeout = 5000;
    private int readTimeout = 15000;
    private boolean failFast = false;
    @Nullable
    private String token;
    private AppIdProperties appId = new AppIdProperties();
    private AppRoleProperties appRole = new AppRoleProperties();
    private AwsEc2Properties awsEc2 = new AwsEc2Properties();
    private AwsIamProperties awsIam = new AwsIamProperties();
    private AzureMsiProperties azureMsi = new AzureMsiProperties();
    private GcpGceProperties gcpGce = new GcpGceProperties();
    private GcpIamProperties gcpIam = new GcpIamProperties();
    private KubernetesProperties kubernetes = new KubernetesProperties();
    private PcfProperties pcf = new PcfProperties();
    private Ssl ssl = new Ssl();
    private Config config = new Config();
    private Session session = new Session();
    private String applicationName = "application";
    private AuthenticationMethod authentication = AuthenticationMethod.TOKEN;

    public void setEnvironment(Environment environment) {
        String springAppName = environment.getProperty("spring.application.name");
        if (StringUtils.hasText((String)springAppName)) {
            this.applicationName = springAppName;
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    @Nullable
    public String getUri() {
        return this.uri;
    }

    public void setUri(@Nullable String uri) {
        this.uri = uri;
    }

    @Nullable
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(@Nullable String namespace) {
        this.namespace = namespace;
    }

    public Reactive getReactive() {
        return this.reactive;
    }

    public void setReactive(Reactive reactive) {
        this.reactive = reactive;
    }

    public Discovery getDiscovery() {
        return this.discovery;
    }

    public void setDiscovery(Discovery discovery) {
        this.discovery = discovery;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public boolean isFailFast() {
        return this.failFast;
    }

    public void setFailFast(boolean failFast) {
        this.failFast = failFast;
    }

    @Nullable
    public String getToken() {
        return this.token;
    }

    public void setToken(@Nullable String token) {
        this.token = token;
    }

    public AppIdProperties getAppId() {
        return this.appId;
    }

    public void setAppId(AppIdProperties appId) {
        this.appId = appId;
    }

    public AppRoleProperties getAppRole() {
        return this.appRole;
    }

    public void setAppRole(AppRoleProperties appRole) {
        this.appRole = appRole;
    }

    public AwsEc2Properties getAwsEc2() {
        return this.awsEc2;
    }

    public void setAwsEc2(AwsEc2Properties awsEc2) {
        this.awsEc2 = awsEc2;
    }

    public AwsIamProperties getAwsIam() {
        return this.awsIam;
    }

    public void setAwsIam(AwsIamProperties awsIam) {
        this.awsIam = awsIam;
    }

    public AzureMsiProperties getAzureMsi() {
        return this.azureMsi;
    }

    public void setAzureMsi(AzureMsiProperties azureMsi) {
        this.azureMsi = azureMsi;
    }

    public GcpGceProperties getGcpGce() {
        return this.gcpGce;
    }

    public void setGcpGce(GcpGceProperties gcpGce) {
        this.gcpGce = gcpGce;
    }

    public GcpIamProperties getGcpIam() {
        return this.gcpIam;
    }

    public void setGcpIam(GcpIamProperties gcpIam) {
        this.gcpIam = gcpIam;
    }

    public KubernetesProperties getKubernetes() {
        return this.kubernetes;
    }

    public void setKubernetes(KubernetesProperties kubernetes) {
        this.kubernetes = kubernetes;
    }

    public PcfProperties getPcf() {
        return this.pcf;
    }

    public void setPcf(PcfProperties pcf) {
        this.pcf = pcf;
    }

    public Ssl getSsl() {
        return this.ssl;
    }

    public void setSsl(Ssl ssl) {
        this.ssl = ssl;
    }

    public Config getConfig() {
        return this.config;
    }

    public void setConfig(Config config) {
        this.config = config;
    }

    public Session getSession() {
        return this.session;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public AuthenticationMethod getAuthentication() {
        return this.authentication;
    }

    public void setAuthentication(AuthenticationMethod authentication) {
        this.authentication = authentication;
    }

    public static class Reactive {
        private boolean enabled = true;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }
    }

    public static class Discovery {
        public static final String DEFAULT_VAULT = "vault";
        private boolean enabled;
        private String serviceId = "vault";

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public String getServiceId() {
            return this.serviceId;
        }

        public void setServiceId(String serviceId) {
            this.serviceId = serviceId;
        }
    }

    public static class AppIdProperties {
        public static final String MAC_ADDRESS = "MAC_ADDRESS";
        public static final String IP_ADDRESS = "IP_ADDRESS";
        private String appIdPath = "app-id";
        @Nullable
        private String networkInterface;
        private String userId = "MAC_ADDRESS";

        public String getAppIdPath() {
            return this.appIdPath;
        }

        public void setAppIdPath(String appIdPath) {
            this.appIdPath = appIdPath;
        }

        @Nullable
        public String getNetworkInterface() {
            return this.networkInterface;
        }

        public void setNetworkInterface(@Nullable String networkInterface) {
            this.networkInterface = networkInterface;
        }

        public String getUserId() {
            return this.userId;
        }

        public void setUserId(String userId) {
            this.userId = userId;
        }
    }

    public static class AppRoleProperties {
        private String appRolePath = "approle";
        private String role = "";
        @Nullable
        private String roleId;
        @Nullable
        private String secretId;

        public String getAppRolePath() {
            return this.appRolePath;
        }

        public void setAppRolePath(String appRolePath) {
            this.appRolePath = appRolePath;
        }

        public String getRole() {
            return this.role;
        }

        public void setRole(String role) {
            this.role = role;
        }

        @Nullable
        public String getRoleId() {
            return this.roleId;
        }

        public void setRoleId(@Nullable String roleId) {
            this.roleId = roleId;
        }

        @Nullable
        public String getSecretId() {
            return this.secretId;
        }

        public void setSecretId(@Nullable String secretId) {
            this.secretId = secretId;
        }
    }

    public static class AwsEc2Properties {
        private URI identityDocument = URI.create("http://169.254.169.254/latest/dynamic/instance-identity/pkcs7");
        private String awsEc2Path = "aws-ec2";
        private String role = "";
        @Nullable
        private String nonce;

        public URI getIdentityDocument() {
            return this.identityDocument;
        }

        public void setIdentityDocument(URI identityDocument) {
            this.identityDocument = identityDocument;
        }

        public String getAwsEc2Path() {
            return this.awsEc2Path;
        }

        public void setAwsEc2Path(String awsEc2Path) {
            this.awsEc2Path = awsEc2Path;
        }

        public String getRole() {
            return this.role;
        }

        public void setRole(String role) {
            this.role = role;
        }

        @Nullable
        public String getNonce() {
            return this.nonce;
        }

        public void setNonce(@Nullable String nonce) {
            this.nonce = nonce;
        }
    }

    public static class AwsIamProperties {
        private String awsPath = "aws";
        private String region = "";
        private String role = "";
        @Nullable
        private String serverName;
        @Nullable
        private URI endpointUri;

        public String getAwsPath() {
            return this.awsPath;
        }

        public String getRegion() {
            return this.region;
        }

        public String getRole() {
            return this.role;
        }

        @Nullable
        public String getServerName() {
            return this.serverName;
        }

        public void setAwsPath(String awsPath) {
            this.awsPath = awsPath;
        }

        public void setRegion(String region) {
            this.region = region;
        }

        public void setRole(String role) {
            this.role = role;
        }

        public void setServerName(String serverName) {
            this.serverName = serverName;
        }

        @Nullable
        public URI getEndpointUri() {
            return this.endpointUri;
        }

        public void setEndpointUri(URI endpointUri) {
            this.endpointUri = endpointUri;
        }
    }

    public static class AzureMsiProperties {
        private String azurePath = "azure";
        private String role = "";
        private URI metadataService = AzureMsiAuthenticationOptions.DEFAULT_INSTANCE_METADATA_SERVICE_URI;
        private URI identityTokenService = AzureMsiAuthenticationOptions.DEFAULT_IDENTITY_TOKEN_SERVICE_URI;

        public String getAzurePath() {
            return this.azurePath;
        }

        public void setAzurePath(String azurePath) {
            this.azurePath = azurePath;
        }

        public String getRole() {
            return this.role;
        }

        public void setRole(String role) {
            this.role = role;
        }

        public URI getMetadataService() {
            return this.metadataService;
        }

        public void setMetadataService(URI metadataService) {
            this.metadataService = metadataService;
        }

        public URI getIdentityTokenService() {
            return this.identityTokenService;
        }

        public void setIdentityTokenService(URI identityTokenService) {
            this.identityTokenService = identityTokenService;
        }
    }

    public static class GcpGceProperties {
        private String gcpPath = "gcp";
        private String role = "";
        private String serviceAccount = "";

        public String getGcpPath() {
            return this.gcpPath;
        }

        public String getRole() {
            return this.role;
        }

        public String getServiceAccount() {
            return this.serviceAccount;
        }

        public void setGcpPath(String gcpPath) {
            this.gcpPath = gcpPath;
        }

        public void setRole(String role) {
            this.role = role;
        }

        public void setServiceAccount(String serviceAccount) {
            this.serviceAccount = serviceAccount;
        }
    }

    public static class GcpIamProperties {
        private final GcpCredentials credentials = new GcpCredentials();
        private String gcpPath = "gcp";
        private String role = "";
        private String projectId = "";
        private String serviceAccountId = "";
        private Duration jwtValidity = Duration.ofMinutes(15L);

        public GcpCredentials getCredentials() {
            return this.credentials;
        }

        public String getGcpPath() {
            return this.gcpPath;
        }

        public String getRole() {
            return this.role;
        }

        public String getProjectId() {
            return this.projectId;
        }

        public String getServiceAccountId() {
            return this.serviceAccountId;
        }

        public Duration getJwtValidity() {
            return this.jwtValidity;
        }

        public void setGcpPath(String gcpPath) {
            this.gcpPath = gcpPath;
        }

        public void setRole(String role) {
            this.role = role;
        }

        public void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        public void setServiceAccountId(String serviceAccountId) {
            this.serviceAccountId = serviceAccountId;
        }

        public void setJwtValidity(Duration jwtValidity) {
            this.jwtValidity = jwtValidity;
        }
    }

    public static class KubernetesProperties {
        private String kubernetesPath = "kubernetes";
        private String role = "";
        private String serviceAccountTokenFile = "/var/run/secrets/kubernetes.io/serviceaccount/token";

        public String getKubernetesPath() {
            return this.kubernetesPath;
        }

        public String getRole() {
            return this.role;
        }

        public String getServiceAccountTokenFile() {
            return this.serviceAccountTokenFile;
        }

        public void setKubernetesPath(String kubernetesPath) {
            this.kubernetesPath = kubernetesPath;
        }

        public void setRole(String role) {
            this.role = role;
        }

        public void setServiceAccountTokenFile(String serviceAccountTokenFile) {
            this.serviceAccountTokenFile = serviceAccountTokenFile;
        }
    }

    public static class PcfProperties {
        private String pcfPath = "pcf";
        private String role = "";
        @Nullable
        private Resource instanceCertificate;
        @Nullable
        private Resource instanceKey;

        public String getPcfPath() {
            return this.pcfPath;
        }

        public void setPcfPath(String pcfPath) {
            this.pcfPath = pcfPath;
        }

        public String getRole() {
            return this.role;
        }

        public void setRole(String role) {
            this.role = role;
        }

        @Nullable
        public Resource getInstanceCertificate() {
            return this.instanceCertificate;
        }

        public void setInstanceCertificate(@Nullable Resource instanceCertificate) {
            this.instanceCertificate = instanceCertificate;
        }

        @Nullable
        public Resource getInstanceKey() {
            return this.instanceKey;
        }

        public void setInstanceKey(@Nullable Resource instanceKey) {
            this.instanceKey = instanceKey;
        }
    }

    public static class Ssl {
        @Nullable
        private Resource keyStore;
        @Nullable
        private String keyStorePassword;
        @Nullable
        private String keyStoreType;
        @Nullable
        private Resource trustStore;
        @Nullable
        private String trustStorePassword;
        @Nullable
        private String trustStoreType;
        private String certAuthPath = "cert";
        private List<String> enabledProtocols = new ArrayList<String>();
        private List<String> enabledCipherSuites = new ArrayList<String>();

        @Nullable
        public Resource getKeyStore() {
            return this.keyStore;
        }

        public void setKeyStore(@Nullable Resource keyStore) {
            this.keyStore = keyStore;
        }

        @Nullable
        public String getKeyStorePassword() {
            return this.keyStorePassword;
        }

        public void setKeyStorePassword(@Nullable String keyStorePassword) {
            this.keyStorePassword = keyStorePassword;
        }

        @Nullable
        public String getKeyStoreType() {
            return this.keyStoreType;
        }

        public void setKeyStoreType(@Nullable String keyStoreType) {
            this.keyStoreType = keyStoreType;
        }

        @Nullable
        public Resource getTrustStore() {
            return this.trustStore;
        }

        public void setTrustStore(@Nullable Resource trustStore) {
            this.trustStore = trustStore;
        }

        @Nullable
        public String getTrustStorePassword() {
            return this.trustStorePassword;
        }

        public void setTrustStorePassword(@Nullable String trustStorePassword) {
            this.trustStorePassword = trustStorePassword;
        }

        @Nullable
        public String getTrustStoreType() {
            return this.trustStoreType;
        }

        public void setTrustStoreType(@Nullable String trustStoreType) {
            this.trustStoreType = trustStoreType;
        }

        public String getCertAuthPath() {
            return this.certAuthPath;
        }

        public void setCertAuthPath(String certAuthPath) {
            this.certAuthPath = certAuthPath;
        }

        public List<String> getEnabledProtocols() {
            return this.enabledProtocols;
        }

        public void setEnabledProtocols(List<String> enabledProtocols) {
            this.enabledProtocols = enabledProtocols;
        }

        public List<String> getEnabledCipherSuites() {
            return this.enabledCipherSuites;
        }

        public void setEnabledCipherSuites(List<String> enabledCipherSuites) {
            this.enabledCipherSuites = enabledCipherSuites;
        }
    }

    public static class Config {
        private int order = 0;
        private ConfigLifecycle lifecycle = new ConfigLifecycle();

        @DeprecatedConfigurationProperty(reason="Only required for deprecated Bootstrap Context usage")
        public int getOrder() {
            return this.order;
        }

        public ConfigLifecycle getLifecycle() {
            return this.lifecycle;
        }

        public void setOrder(int order) {
            this.order = order;
        }

        public void setLifecycle(ConfigLifecycle lifecycle) {
            this.lifecycle = lifecycle;
        }
    }

    public static class Session {
        private SessionLifecycle lifecycle = new SessionLifecycle();

        public SessionLifecycle getLifecycle() {
            return this.lifecycle;
        }

        public void setLifecycle(SessionLifecycle lifecycle) {
            this.lifecycle = lifecycle;
        }
    }

    public static enum AuthenticationMethod {
        APPID,
        APPROLE,
        AWS_EC2,
        AWS_IAM,
        AZURE_MSI,
        CERT,
        CUBBYHOLE,
        GCP_GCE,
        GCP_IAM,
        KUBERNETES,
        NONE,
        PCF,
        TOKEN;

    }

    public static class SessionLifecycle {
        private boolean enabled = true;
        private Duration refreshBeforeExpiry = Duration.ofSeconds(5L);
        private Duration expiryThreshold = Duration.ofSeconds(7L);

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public Duration getRefreshBeforeExpiry() {
            return this.refreshBeforeExpiry;
        }

        public void setRefreshBeforeExpiry(Duration refreshBeforeExpiry) {
            this.refreshBeforeExpiry = refreshBeforeExpiry;
        }

        public Duration getExpiryThreshold() {
            return this.expiryThreshold;
        }

        public void setExpiryThreshold(Duration expiryThreshold) {
            this.expiryThreshold = expiryThreshold;
        }
    }

    static enum PredefinedLeaseStrategy {
        RetainOnError,
        RetainOnIoError,
        DropOnError;

    }

    public static class ConfigLifecycle {
        private boolean enabled = true;
        @Nullable
        private Duration minRenewal;
        @Nullable
        private Duration expiryThreshold;
        @Nullable
        private LeaseEndpoints leaseEndpoints;
        @Nullable
        private PredefinedLeaseStrategy leaseStrategy;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        @Nullable
        public Duration getMinRenewal() {
            return this.minRenewal;
        }

        public void setMinRenewal(@Nullable Duration minRenewal) {
            this.minRenewal = minRenewal;
        }

        @Nullable
        public Duration getExpiryThreshold() {
            return this.expiryThreshold;
        }

        public void setExpiryThreshold(@Nullable Duration expiryThreshold) {
            this.expiryThreshold = expiryThreshold;
        }

        @Nullable
        public LeaseEndpoints getLeaseEndpoints() {
            return this.leaseEndpoints;
        }

        public void setLeaseEndpoints(@Nullable LeaseEndpoints leaseEndpoints) {
            this.leaseEndpoints = leaseEndpoints;
        }

        @Nullable
        public PredefinedLeaseStrategy getLeaseStrategy() {
            return this.leaseStrategy;
        }

        public void setLeaseStrategy(@Nullable PredefinedLeaseStrategy leaseStrategy) {
            this.leaseStrategy = leaseStrategy;
        }
    }

    public static class GcpCredentials {
        private Resource location;
        private String encodedKey;

        public Resource getLocation() {
            return this.location;
        }

        public String getEncodedKey() {
            return this.encodedKey;
        }

        public void setLocation(Resource location) {
            this.location = location;
        }

        public void setEncodedKey(String encodedKey) {
            this.encodedKey = encodedKey;
        }
    }
}

